/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.rest.column;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.metadata.MetadataAccessor;
import com.comalatech.confluence.adhoclists.rest.AbstractChecklistResources;
import com.comalatech.confluence.adhoclists.rest.AbstractRestResources;
import com.comalatech.confluence.adhoclists.rest.PermissionRequired;
import com.comalatech.confluence.adhoclists.storage.serializer.ChecklistSerializer;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/lists/metadata")
public class MetadataResources
extends AbstractChecklistResources {
    private MetadataAccessor metadataAccessor;
    private WikiStyleRenderer wikiStyleRenderer;

    public MetadataResources(PageManager pageManager, SpaceManager spaceManager, PermissionManager permissionManager, LabelManager labelManager, FilterManager filterManager, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, AdhocTemplateManager adhocTemplateManager, PageTemplateManager pageTemplateManager, I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator, @Qualifier(value="checklistJsonSerializer") ChecklistSerializer checklistSerializer, MetadataAccessor metadataAccessor, WikiStyleRenderer wikiStyleRenderer) {
        super(pageManager, spaceManager, permissionManager, labelManager, filterManager, contentEntityManager, adhocTemplateManager, pageTemplateManager, i18nResolver, restCondition, boardValidator, checklistSerializer);
        this.metadataAccessor = metadataAccessor;
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT})
    @POST
    @Path(value="/{pageId}/set")
    @Produces(value={"text/html"})
    @Consumes(value={"application/json"})
    public Response setMetadata(@PathParam(value="pageId") long pageId, final @QueryParam(value="valueName") String valueName, final @QueryParam(value="renderWikiMarkup") boolean render, final String value) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws AdhocListsException {
                MetadataResources.this.metadataAccessor.setValue(page, valueName, value);
                String renderedResponse = render ? MetadataResources.this.renderMetadata(page, value) : "";
                Response response = Response.ok((Object)renderedResponse).build();
                return response;
            }
        }.execute(pageId);
    }

    private String renderMetadata(AbstractPage page, String value) {
        PageContext context = page.toPageContext();
        context.pushRenderMode(RenderMode.suppress((long)256L));
        String renderedHtml = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, value);
        return renderedHtml;
    }
}

