/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.model;

import java.util.HashMap;
import java.util.Map;

public class Styles {
    private static final Scheme DEFAULT_SCHEME = new Scheme("", "#69808d", "#eaefee", "#e2e8e7", Contrast.NORMAL);
    private static final Scheme HIDDEN_SCHEME = new Scheme("hiddenstyle", "", "", "", Contrast.NORMAL);
    private static final Scheme[] SCHEMES = new Scheme[]{new Scheme("#4d4d4d", "#e6e6e6", "#cccccc", Contrast.NORMAL), new Scheme("#f2600f", "#f2ddd6", "#efb69a", Contrast.NORMAL), new Scheme("#c1272d", "#f4dfe3", "#e2a6af", Contrast.NORMAL), new Scheme("#8cc63f", "#d5ddc7", "#becca6", Contrast.NORMAL), new Scheme("#0bb1dd", "#c7e6ea", "#b3e1e8", Contrast.NORMAL), new Scheme("#c9c965", "#e2e0d3", "#dddac3", Contrast.NORMAL), new Scheme("#6b635c", "#eae6e4", "#ccc7c2", Contrast.NORMAL), new Scheme("#c9d912", "#efeee8", "#e0ded7", Contrast.NORMAL), new Scheme("#ee2a7b", "#f7edf3", "#eadfe5", Contrast.NORMAL), new Scheme("#754a54", "#eae6e4", "#dddad7", Contrast.NORMAL), new Scheme("#b8e2df", "#eaefee", "#e2e8e7", Contrast.NORMAL), new Scheme("#69808d", "#eaefee", "#e2e8e7", Contrast.NORMAL), new Scheme("#bbbbbb", "#f0f0f0", "#e3e3e3", Contrast.NORMAL), new Scheme("#ff0000", "#ededed", "#dbdbdb", Contrast.NORMAL), new Scheme("#f4ee19", "#ededed", "#dbdbdb", Contrast.DARK), new Scheme("#088408", "#ededed", "#dbdbdb", Contrast.NORMAL), new Scheme("#6699cc", "#d9e6f2", "#b3cce6", Contrast.NORMAL), new Scheme("#ffde8e", "#ffffdb", "#ffffc2", Contrast.DARK, true), new Scheme("#75c79e", "#cefcdd", "#b6fbcc", Contrast.DARK), new Scheme("#f69297", "#ffe5e6", "#ffcccd", Contrast.MEDIUM), new Scheme("#8db0d6", "#d8e4f1", "#c5d7ea", Contrast.MEDIUM), new Scheme("#ffc280", "#fff3e6", "#ffe4c7", Contrast.MEDIUM, true), new Scheme("#99ff80", "#ebffe6", "#d6ffcd", Contrast.MEDIUM, true), new Scheme("#c280ff", "#f3e6ff", "#e7ceff", Contrast.MEDIUM, true), new Scheme("#ff808f", "#ffe6e9", "#ffd0d6", Contrast.MEDIUM, true), new Scheme("#4375a6", "#f2f0f0", "#d7e5f3", Contrast.NORMAL), new Scheme("#14892c", "#f2f0f0", "#89c495", Contrast.NORMAL), new Scheme("#ffd351", "#f2f0f0", "#ffe9a8", Contrast.DARK), new Scheme("#815b3a", "#f2f0f0", "#e3e3e2", Contrast.NORMAL), new Scheme("#d04437", "#f2f0f0", "#e3e3e2", Contrast.NORMAL), new Scheme("#707070", "#f2f0f0", "#e3e3e2", Contrast.NORMAL), new Scheme("#4a6785", "#f2f0f0", "#e3e3e2", Contrast.NORMAL), new Scheme("#33567a", "#f2f0f0", "#e3e3e2", Contrast.NORMAL), new Scheme("#f4a019", "#f2f0f0", "#e3e3e2", Contrast.NORMAL), new Scheme("#2c77bf", "#f2f0f0", "#e3e3e2", Contrast.NORMAL)};
    private static final Styles INSTANCE = new Styles(SCHEMES);
    private String[] styles;
    private Scheme[] schemes;
    private Scheme[] activeSchemes;
    private Map<String, Scheme> schemesMap;
    private static int COUNT = 0;

    private Styles(Scheme[] schemes) {
        this.schemes = schemes;
        this.styles = new String[schemes.length];
        this.schemesMap = new HashMap<String, Scheme>(schemes.length);
        int ix = 0;
        Scheme previous = null;
        int active = 0;
        for (Scheme scheme : schemes) {
            this.styles[ix++] = scheme.name;
            this.schemesMap.put(scheme.name, scheme);
            if (previous != null) {
                previous.next = scheme;
            }
            previous = scheme;
            if (scheme.deprecated) continue;
            ++active;
        }
        previous.next = schemes[0];
        this.schemesMap.put(HIDDEN_SCHEME.getName(), HIDDEN_SCHEME);
        this.activeSchemes = new Scheme[active];
        ix = 0;
        for (Scheme scheme : schemes) {
            if (scheme.deprecated) continue;
            this.activeSchemes[ix++] = scheme;
        }
    }

    public String[] getStyles() {
        return this.styles;
    }

    public Scheme[] getSchemes() {
        return this.schemes;
    }

    public Scheme[] getActiveSchemes() {
        return this.activeSchemes;
    }

    public Scheme getDefaultScheme() {
        return DEFAULT_SCHEME;
    }

    public Scheme getScheme(String name) {
        Scheme scheme = this.schemesMap.get(name);
        if (scheme == null) {
            scheme = DEFAULT_SCHEME;
        }
        return scheme;
    }

    public static Styles getInstance() {
        return INSTANCE;
    }

    public static String getCompositeStyle(String styleName) {
        return INSTANCE.getScheme(styleName).getCompositeStyle();
    }

    public static String getStyle(int i) {
        return INSTANCE.getStyles()[i % INSTANCE.getStyles().length];
    }

    public static enum Contrast {
        NORMAL(""),
        MEDIUM("contrast_medium"),
        DARK("contrast_dark");

        String className;

        private Contrast(String className) {
            this.className = className;
        }

        public String toString() {
            return this.className;
        }
    }

    public static class Scheme {
        String name;
        String headerBackground;
        String bodyBackground;
        String focusBodyBackground;
        Contrast contrast;
        String compositeStyle;
        Scheme next;
        boolean deprecated;

        public Scheme(String name, String headerBackground, String bodyBackground, String focusBodyBackground, Contrast contrast) {
            this.name = name;
            this.headerBackground = headerBackground;
            this.bodyBackground = bodyBackground;
            this.focusBodyBackground = focusBodyBackground;
            this.contrast = contrast;
            this.compositeStyle = contrast == Contrast.NORMAL ? name : name + " " + (Object)((Object)contrast);
        }

        public Scheme(String headerBackground, String bodyBackground, String focusBodyBackground, Contrast contrast) {
            this(String.format("s%03d", COUNT++), headerBackground, bodyBackground, focusBodyBackground, contrast);
        }

        public Scheme(String headerBackground, String bodyBackground, String focusBodyBackground, Contrast contrast, boolean deprecated) {
            this(String.format("s%03d", COUNT++), headerBackground, bodyBackground, focusBodyBackground, contrast);
            this.deprecated = deprecated;
        }

        public String getName() {
            return this.name;
        }

        public String getHeaderBackground() {
            return this.headerBackground;
        }

        public String getBodyBackground() {
            return this.bodyBackground;
        }

        public String getFocusBodyBackground() {
            return this.focusBodyBackground;
        }

        public Scheme getNext() {
            return this.next;
        }

        public void setNext(Scheme next) {
            this.next = next;
        }

        public String getCompositeStyle() {
            return this.compositeStyle;
        }
    }
}

