/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.metadata;

import com.comalatech.confluence.adhoclists.metadata.MetadataManagerAccessor;
import com.comalatech.confluence.adhoclists.metadata.MetadataManagerFactory;
import com.comalatech.confluence.adhoclists.metadata.MetadataManagerHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MetadataManagerAccessorImpl
implements MetadataManagerAccessor {
    private static final Logger log = LoggerFactory.getLogger(MetadataManagerAccessorImpl.class);
    private final ApplicationContext applicationContext;
    private MetadataManagerHolder metadataManagerHolder;

    public MetadataManagerAccessorImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private void initMetadataManager() {
        try {
            Class<?> metadataManagerClass = this.getMetadataManagerClass();
            if (metadataManagerClass != null) {
                this.metadataManagerHolder = ((MetadataManagerFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(metadataManagerClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.error("Could not create MetadataManagerHolder", (Throwable)e);
        }
    }

    private Class<?> getMetadataManagerClass() {
        try {
            this.getClass().getClassLoader().loadClass("com.servicerocket.confluence.randombits.metadata.MetadataManager");
            return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.adhoclists.metadata.MetadataManagerFactory");
        }
        catch (Exception e) {
            log.info("The necessary supplier class is unavailable.");
            return null;
        }
    }

    @Override
    public synchronized MetadataManagerHolder getMetadataManager() {
        if (this.metadataManagerHolder == null) {
            this.initMetadataManager();
        }
        return this.metadataManagerHolder;
    }
}

