/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.cards;

import com.comalatech.confluence.adhoclists.cards.model.Card;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;

public class CardsUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String normalizeKey(String key) {
        if (key == null) {
            return "";
        }
        Object[] keys = key.toLowerCase().replaceAll("[^,A-Za-z0-9_\\-]", "").split(",");
        Arrays.sort(keys);
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (Object k : keys) {
            sb.append(separator).append((String)k);
            separator = ",";
        }
        return sb.toString();
    }

    public static String toJson(List<Card> cards) {
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, cards);
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<Card> fromJson(String cards) throws Exception {
        return (List)mapper.readValue(cards, (TypeReference)new TypeReference<List<Card>>(){});
    }

    public static String keysToJson(List<String> keys) {
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, keys);
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<String> keysFromJson(String keys) throws Exception {
        return (List)mapper.readValue(keys, (TypeReference)new TypeReference<List<String>>(){});
    }

    static {
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

