/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};

var debugo = debugo || {};

(function ($) {

    var addContainer = function($column) {
        $column.append(Adhoc.sanitizeBoardContent(AJS.template.load("board-container").fill().toString()));
        Adhoc.initDesignBoard();
        getLastContainerStyle($column.find(".boardcontainer:last"));
    };

    var getLastContainerStyle = function($container) {
        var last = "";
        $(".boardcontainer").each(function() {
            if ($(this).attr("containerstyle") && $(this).attr("containerstyle").length > 0) {
                last = $(this).attr("containerstyle");
            }
        });
        var style;
        if (last.length == 0) {
            style = $(".stylepicker:first",$container).attr("styleId");
        } else {
            style = $(".stylepicker." + last,$container).attr("nextStyleId");
        }
        $container.addClass(style).attr("containerstyle",style);
    };

    var editContainer = function($container) {
        var caption = $container.find(".containercaption").text();
        var label = $container.attr("containerkey");
        $container.find("input[name='containercaption']").val(caption);
        $container.find("input[name='containerlabel']").val(label);
        $container.addClass("edit");
        $container.find("input[name='containercaption']").keyup();
    };

    var removeContainer = function($container) {
        if ($container.hasClass("new")) {
            $container.remove();
            return;
        }
        Adhoc.doIfconfirm($container.find(".containercaption").text(),
                AJS.I18n.getText("adhoclists.boards.designer.container.delete.confirm"),function() {
            $container.remove();
        });
    };

    var addColumn = function($row) {
        if ($row.find("td").length > 0) {
            $row.find("td:last").after(Adhoc.sanitizeBoardContent(AJS.template.load("board-column").fill().toString()));
        } else {
            $row.append(Adhoc.sanitizeBoardContent(AJS.template.load("board-column").fill().toString()));
        }
        resizeColumns($row);
        Adhoc.initDesignBoard();
    };

    var resizeColumns = function ($row) {
        var $columns = $row.find("td");
        var width = 100 / $columns.length;
        $columns.attr("width", width + "%");
    };

    var doRemoveColumn = function($column) {
        var row = $column.parents("tr.columnsrow");
        $column.remove();
        resizeColumns(row);
    };

    var removeColumn = function($column) {
        if ($column.find(".boardcontainer").length == 0) {
            doRemoveColumn($column);
            return;
        }
        Adhoc.doIfconfirm(AJS.I18n.getText("adhoclists.boards.designer.column.name"),
                          AJS.I18n.getText("adhoclists.boards.designer.column.delete.confirm"),
                          function() {
                              doRemoveColumn($column);
                          });
    };

    var addRow = function() {
        $("tr.boardrowcontainer:last").after(Adhoc.sanitizeBoardContent(AJS.template.load("board-row").fill().toString()));
        var $row = $("tr.boardrowcontainer:last tr.columnsrow");
        addColumn($row);
    };

    var removeRow = function($row) {
        if ($row.find(".boardcontainer").length == 0) {
            $row.remove();
            return;
        }
        Adhoc.doIfconfirm(AJS.I18n.getText("adhoclists.boards.designer.row.name"),
                  AJS.I18n.getText("adhoclists.boards.designer.row.delete.confirm"),
                  function() {
                      $row.remove();
                  });
    };

    var acceptContainer = function($container) {

        var caption = $container.find("input[name='containercaption']").val();
        var label = $container.find("input[name='containerlabel']").val().toLowerCase().replace(/\s+/g, '');
        caption = AJS.escapeHtml(caption);
        label = AJS.escapeHtml(label);
        if (label.length > 0) {
            if (! Adhoc.common.isValidLabel(label)) {
                Adhoc.common.errorMessage($container.find(".description.error"),AJS.I18n.getText("adhoclists.boards.designer.error.invalid-label"));
                return;
            }
        }
        $container.find(".containercaption").html(caption);
        $container.attr("containerkey",label);
        $container.find(".containerdata").html(label.replace(',', ', '));
        $container.removeClass("edit").removeClass("new");
    };


    var cancelContainer = function($container) {
        $container.removeClass("edit");
        if ($container.hasClass("new")) {
            $container.remove();
        }
    };

    var toggleDetails = function($container) {
        $(".details",$container).toggleClass("hidden");
        $(".moredetails",$container).toggleClass("hidden");
    };

    var selectStyle = function($style) {
        var $container = $style.parents(".boardcontainer");
        var styleId = $style.attr("styleid");
        var newContainer = "";
        if ($container.hasClass("new")) {
            newContainer =" edit new";
        }
        $container.attr("class","boardcontainer " + styleId + newContainer);
        $container.attr("containerstyle",styleId);
    };

    var saveSpaceBoard = function($board) {
        Adhoc.Board.update();
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/json; charset=utf-8",
            url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/boards/" + AJS.params.spaceKey +
                    "/save?labels=" + encodeURIComponent(Adhoc.filter.labelsList()) +
                    "&parent=" + Adhoc.filter.parent(),
            data: Adhoc.Board.toJson(),
            success: function (data, textStatus, jqXHR) {
                window.location = $(".saveboard").attr("href") + "&name=" + Adhoc.Board.board.name;
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Adhoc.common.errorHandler($board,jqXHR, textStatus,errorThrown);
            }
        });
    };

    var previewBoard = function($content) {
        Adhoc.addLargeSpinner($content);
        Adhoc.Board.update();
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/json; charset=utf-8",
            url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/boards/" + Adhoc.Board.spaceKey + "/preview",
            data: Adhoc.Board.toJson(),
            success: function (data, textStatus, jqXHR) {
                $content.empty().append(data);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                $content.empty();
                Adhoc.common.errorHandler($content,jqXHR, textStatus,errorThrown);
            }
        });
    };

    var editRow = function (obj) {
        var $row = $(obj).parents("tr.boardrowcontainer");
        $("form.aui.rowform", $row).toggleClass("hidden");
    };

   var editColumn = function (obj) {
        var $col = $(obj).parents("td.boardcolumntd");
        $("form.aui.columnform", $col).toggleClass("hidden");
    };

    var selectText = function (element) {
        var doc = document,
            text = doc.getElementById(element),
            range,
            selection;

        if (doc.body.createTextRange) { //ms

            console.log('createTextRange')
            range = doc.body.createTextRange();
            range.moveToElementText(text);
            range.select();
        } else if (window.getSelection) { //all others
            console.log('window.getSelection', text)
            selection = window.getSelection();
            range = doc.createRange();
            range.selectNodeContents(text);
            selection.removeAllRanges();
            selection.addRange(range);
        }
    };

    Adhoc.initDesignBoard = function() {
        try {
            $(".boardcolumn").sortable("destroy");
        }
        catch(e) {
        }
        $(".boardcolumn").sortable({
            over: function(event, ui) {
                $(".boarddesigner td").removeClass("hover");
                $(this).parents("td").addClass("hover");
            },
            stop: function(event, ui) {
                $(".boarddesigner td").removeClass("hover");
            },
            connectWith : ".boardcolumn"
        });

        // show header/footer row if with value
        $(".boardaction.editrow").each(function(i, row) {
            var edit = false,
                $row = $(row).parents("tr.boardrowcontainer");

            $("form.aui.rowform input", $row).each(function(i, input) {
                if($(input).val() != "") {
                    edit = true;
                }
            });
            if(edit) {
                editRow(row);
            }
        });

        // show header/footer column if with value
        $(".boardaction.editcolumn").each(function(i, col) {
            var edit = false,
                $col = $(col).parents("td.boardcolumntd");

            $("form.aui.columnform input", $col).each(function(i, input) {
                if($(input).val() != "") {
                    edit = true;
                }
            });
            if(edit) {
                editColumn(col);
            }
        });
        //insert spaces between commas in labels to break words
        $('.containerdata').each(function(index, item){
            var $item = $(item);
            $item.text($item.text().replace(',', ', '));
        });
    };

    AJS.toInit(function ($) {
        $(document).on('click', ".boardaction.addcolumn", function() {
            addColumn($(this).parents("tr.boardrowcontainer").find("table tr"));
            return false;
        });
        $(document).on('click', ".boardaction.editrow", function(event) {
            event.preventDefault();
            editRow(this);
            return false;
        });
        $(document).on('click', ".boardaction.editcolumn", function(event) {
            event.preventDefault();
            editColumn(this);
            return false;
        });
        $(document).on('click', ".boardaction.removecolumn", function() {
            removeColumn($(this).parents("td.boardcolumntd"));
            return false;
        });
        $(document).on('click', ".boardaction.removerow", function() {
            removeRow($(this).parents(".boardrowcontainer"));
            return false;
        });
        $(document).on('click', ".boardaction.addrow", function() {
            addRow();
            return false;
        });
        $(document).on('click', ".boardaction.addcontainer", function() {
            addContainer($(this).parents(".boardcolumntd").find(".boardcolumn"));
            return false;
        });
        $(document).on('click', '.boardaction.removecontainer', function(e) {
            removeContainer($(e.currentTarget).parents(".boardcontainer"));
        });
        $(document).on('click', '.boardaction.sortcontainer', function(e) {
            e.preventDefault();
            return false;
        });
        $(document).on('click', '.stylepicker', function(e) {
            selectStyle($(e.currentTarget));
            e.preventDefault();
            return false;
        });
        $(document).on('click', ".boardaction.editcontainer, .boardaction.editcontainer2", function(event) {
            event.preventDefault();
            editContainer($(this).parents(".boardcontainer"));
        });
        $(document).on('click', ".acceptcontainer", function( event) {
            event.preventDefault();
            acceptContainer($(this).parents(".boardcontainer"));
        });
        $(document).on('click', ".cancelcontainer", function(event) {
            event.preventDefault();
            cancelContainer($(this).parents(".boardcontainer"));
        });
        $(document).on('click', ".moredetails a", function(event) {
            event.preventDefault();
            toggleDetails($(this).parents(".boardcontainer"));
        });

        AJS.$(document).on('change', "input[name='containercaption']", function() {
            $(this).parents("form").find(".acceptcontainer").toggleButton($(this));
            // auto-fill label field
            var $label = $(this).next("input[name='containerlabel']");
            if (!$label.val().length){
                $label.val(Adhoc.common.convertToLabel( $(this).val()));
            }
        });
        AJS.$(document).on('keyup', "input[name='containercaption']", function() {
            $(this).parents("form").find(".acceptcontainer").toggleButton($(this));
        });
        Adhoc.initDesignBoard();
        AJS.$(".saveboard").click(function() {
            saveSpaceBoard($(".boarddesigner"));
            return false;
        });
        AJS.$(".continueboard").click(function(event) {
            event.preventDefault();
            $(".spaceboarddesigner").removeClass("NEW");
            AJS.tabs.change(AJS.$("a[href=#board-editor-tab]"))
        });
        AJS.$(".boardproperties").submit( function(event){
            event.preventDefault();
            $(".spaceboarddesigner").removeClass("NEW");
            AJS.tabs.change(AJS.$("a[href=#board-editor-tab]"))
        });
        $("#board-tabs").bind("tabSelect",function(event, selected) {
            if (selected.pane.attr("id") == "board-preview-tab") {
                previewBoard(selected.pane);
            }
        });
        $("#boardname").change(function() {
            $(".saveboard,.continueboard").toggleButton($(this));
        }).change();
        $("#boardname").keyup(function() {
            $(".saveboard,.continueboard").toggleButton($(this));
        }).change();

        $(document).on('click', "#board-markup-with-cards-trigger", function( event){
            $("div#board-markup").slideToggle();
            $("div#board-markup-with-cards").slideToggle();
        });
        $(document).delegate("#board-markup-text", "click", function(){
            selectText("board-markup-text");
        });
        $(document).delegate("#board-markup-text-cards", "click", function(){
            selectText("board-markup-text-cards");
        });
    });
})(AJS.$);
