/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class BoardDisplayServlet
extends HttpServlet {
    private static final String RESOURCE = "resource";
    private final String TEMPLATE = "boards/templates/boards-main.vm";
    private final TemplateRenderer renderer;
    private String resource;
    protected final AdhocLicenseManager licenseManager;

    @Autowired
    public BoardDisplayServlet(TemplateRenderer renderer, AdhocLicenseManager licenseManager) {
        this.renderer = renderer;
        this.licenseManager = licenseManager;
    }

    public void init() {
        this.resource = this.getServletConfig().getInitParameter(RESOURCE);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("resp", response);
        context.put("urlMode", UrlMode.AUTO);
        context.put("scope", Collections.singletonList(this.resource));
        context.put("lang", request.getParameter("loc").substring(0, 2));
        context.put("isDevelopment", this.licenseManager.isDevelopmentInstance());
        HashMap<String, String> cml = new HashMap<String, String>();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        cml.put("cp", request.getContextPath());
        cml.put("ns", "cb");
        cml.put("plugincp", "/plugins/servlet/boards");
        cml.put("username", user != null ? user.getName() : "");
        context.put("CML", cml);
        this.renderer.render("boards/templates/boards-main.vm", context, (Writer)response.getWriter());
    }
}

