/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.mywork;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;

public class AdhocCanvasDynamicRegistration
implements BundleContextAware,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AdhocCanvasDynamicRegistration.class);
    private final List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void afterPropertiesSet() throws Exception {
        log.info("Attempting to register Adhoc Canvas In App Notification Services");
        this.register("com.atlassian.mywork.service.RegistrationProvider", "com.comalatech.confluence.adhoclists.mywork.AdhocCanvasRegistrationProvider", new Class[0], new Object[0]);
    }

    private void register(String type, String service, Class[] clazz, Object ... args) {
        try {
            Class<?> aClass = this.getClass().getClassLoader().loadClass(service);
            this.registrations.add(this.bundleContext.registerService(type, aClass.getConstructor(clazz).newInstance(args), null));
        }
        catch (NoClassDefFoundError e) {
            log.warn("Could not find Notification and Task libraries, not registering Adhoc Canvas In App Notification Services");
        }
        catch (Exception e) {
            log.warn("Unknown exception, not registering Adhoc In App Notification Services");
            e.printStackTrace();
        }
    }

    public void destroy() throws Exception {
        for (ServiceRegistration registration : this.registrations) {
            registration.unregister();
        }
    }
}

