/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards;

import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.Container;
import com.comalatech.confluence.boards.model.LabelContainer;
import com.comalatech.confluence.boards.util.BoardUtils;
import java.util.HashSet;
import java.util.Set;

public class DefaultBoardValidator
implements BoardValidator {
    protected I18NBeanFactory i18nBeanFactory;

    public DefaultBoardValidator(I18NBeanFactory i18nBeanFactory) {
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Override
    public Set<BoardValidator.BoardValidationError> validate(Board board) {
        if (Board.Type.LABEL.equals((Object)board.getType())) {
            return this.validateLabelBoard(board);
        }
        return new HashSet<BoardValidator.BoardValidationError>();
    }

    protected Set<BoardValidator.BoardValidationError> validateLabelBoard(Board board) {
        HashSet<BoardValidator.BoardValidationError> errors = new HashSet<BoardValidator.BoardValidationError>();
        for (Board.Row row : board.getRows()) {
            for (Board.Column column : row.getColumns()) {
                for (Container container : column.getContainers()) {
                    if (this.isValidLabels(container.getKey())) continue;
                    errors.add(new BoardValidator.BoardValidationError(container.getKey(), this.i18nBeanFactory.getI18NBean().getText("adhoclists.boards.designer.error.invalid-label")));
                }
            }
        }
        return errors;
    }

    @Override
    public boolean isValidLabels(String labels) {
        for (String labelString : new LabelContainer(new Container(labels)).getLabelStringList()) {
            ParsedLabelName parsedLabelName;
            if (labelString.startsWith("@")) {
                labelString = BoardUtils.getPersonalPageLabelFromUsername(labelString.substring(1));
            }
            if ((parsedLabelName = LabelParser.parse((String)labelString, (User)AuthenticatedUserThreadLocal.get())) != null) continue;
            return false;
        }
        return true;
    }
}

