/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Canvas = Canvas || {};

(function ($) {
    if (Canvas.initialized("view.filters")) {
        return;
    }
    Canvas.Filter = function($table) {
        this.labels = $(".cnv-filter input[name='adhocFilterLabels']", $table).val();
        this.depth = $(".cnv-filter input[name='adhocFilterDepth']",$table).val();
        this.parentId = $(".cnv-filter input[name='adhocFilterParentId']", $table).val() || 0;
        this.spaceKey = $(".cnv-filter input[name='adhocFilterSpaceKey']", $table).val() || AJS.params.spaceKey;


        this.excludedLabels = $table.data("excludedLabels");
        if (! this.excludedLabels) {
            this.excludedLabels = [];
            $table.data("excludedLabels",this.excludedLabels);
        }
        this.includedLabels = $table.data("includedLabels");
        if (! this.includedLabels) {
            this.includedLabels = [];
            $table.data("includedLabels",this.includedLabels);
        }
    };

    Canvas.Filter.prototype.addExcludeLabel = function(label) {
        if (this.excludedLabels.indexOf(label) < 0) {
            this.excludedLabels.push(label);
        }
    };

    Canvas.Filter.prototype.addIncludeLabel = function(label) {
        if (this.includedLabels.indexOf(label) < 0) {
            this.includedLabels.push(label);
        }
    };

    Canvas.Filter.prototype.removeExcludeLabel = function(label) {
        for (var i = 0; i < this.excludedLabels.length;i++) {
            if (this.excludedLabels[i] == label) {
                this.excludedLabels.splice(i,1);
            }
        }
    };
    Canvas.Filter.prototype.removeIncludeLabel = function(label) {
        for (var i = 0; i < this.includedLabels.length;i++) {
            if (this.includedLabels[i] == label) {
                this.includedLabels.splice(i,1);
            }
        }
    };

    Canvas.Filter.prototype.allIncludedLabels = function() {
        var allLabels = this.labels,
                separator;
        if (allLabels.length > 0) {
            separator = ",";
        } else {
            separator = "";
        }
        for (var i = 0; i < this.includedLabels.length;i++) {
            allLabels += separator + this.includedLabels[i];
            separator = ",";
        }
        return allLabels;
    };

})(AJS.$);

