/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas.PickerBlueprint = Backbone.View.extend({
    className: 'cnv-wizard-picker',

    events: {
        "canvas:enableCreate" : "enableCreate",
        "canvas:disableCreate" : "disableCreate"
    },

    initialize: function() {
        this.render();
    },

    show: function(createDialog, spaceKey) {
        this.$el.html(
                Canvas.Blueprints.iframe({
                    contextPath: AJS.contextPath(),
                    spaceKey: spaceKey,
                    height: 342
                })
        );
        var $loading = this.$("#cnv-pickerloading");
        var $iframe = this.$("#cnv-pickeriframe");
        $iframe.on("load",function() {
            $loading.remove();
            $iframe.removeClass("hidden");
        });
        var $dialog = AJS.$("#" + createDialog.id);
        this.$createButton = AJS.$(".cnv-blueprint-create",$dialog);
        this.disableCreate();
    },

    enableCreate: function(event, table) {
        this.table = table;
        this.$createButton.prop("aria-disabled","false");
    },


    disableCreate: function() {
        this.$createButton.prop("aria-disabled","true");
    },

    makeBoard: function() {
        return  this.table.get("board");
    },


    render: function() {
        this.$el.html("");
        return this;
    }

});