/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.utils;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityPageHelper {
    private static final Logger log = LoggerFactory.getLogger(VelocityPageHelper.class);
    private WikiStyleRenderer wikiStyleRenderer;
    private XhtmlContent xhtmlContent;

    public VelocityPageHelper(WikiStyleRenderer wikiStyleRenderer, XhtmlContent xhtmlContent) {
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.xhtmlContent = xhtmlContent;
    }

    public String renderMarkupHtml(AbstractPage page, String wiki) {
        if (page == null || !TextUtils.stringSet((String)wiki)) {
            return "";
        }
        PageContext pageContext = page.toPageContext();
        pageContext.pushRenderMode(RenderMode.suppress((long)256L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, wiki);
    }

    public String renderMarkupUnescapedHtml(AbstractPage page, String wiki) {
        PageContext pageContext = page.toPageContext();
        pageContext.pushRenderMode(RenderMode.suppress((long)256L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, StringEscapeUtils.unescapeHtml((String)wiki));
    }

    @HtmlSafe
    public String convertStorageToView(AbstractPage page, String storage) {
        String view = "";
        try {
            DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)page.toPageContext());
            view = this.xhtmlContent.convertStorageToView(storage, (ConversionContext)conversionContext);
        }
        catch (Exception e) {
            log.error("Error parsing macro in storage format to HTML", (Throwable)e);
        }
        return view;
    }

    public WikiStyleRenderer getWikiStyleRenderer() {
        return this.wikiStyleRenderer;
    }
}

