/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.cards.model;

import com.comalatech.confluence.adhoclists.cards.model.Card;
import com.comalatech.confluence.adhoclists.cards.model.ResolvedCard;
import com.comalatech.confluence.boards.rest.model.NewCard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cards {
    private static final Logger log = LoggerFactory.getLogger(Cards.class);
    private ArrayList<Card> cards;
    private boolean dirty;
    private boolean resolved;

    public Cards(List<Card> cards) {
        this.cards = new ArrayList(cards.size());
        for (Card card : cards) {
            card.validate();
            this.cards.add(card);
        }
        this.dirty = false;
        this.resolved = false;
    }

    public boolean synchronize(List<ResolvedCard> entityCards) {
        HashMap<String, Card> cardsById = new HashMap<String, Card>();
        HashMap<String, Card> cardsByTitle = new HashMap<String, Card>();
        for (Card card : this.cards) {
            if (card.getId() != null) {
                cardsById.put(card.getId(), card);
                continue;
            }
            cardsByTitle.put(card.makeTitle(), card);
        }
        HashSet<Card> unmatchedCards = new HashSet<Card>(this.cards);
        for (ResolvedCard entityCard : entityCards) {
            if (entityCard.getId() == null || entityCard.getTitle() == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("# Skipping invalid Resolved Card: " + entityCard);
                continue;
            }
            Card listEntityCard = (Card)cardsById.get(entityCard.getId());
            if (listEntityCard == null) {
                listEntityCard = (Card)cardsByTitle.remove(entityCard.getTitle());
                if (listEntityCard != null) {
                    this.dirty = true;
                    this.replaceCard(listEntityCard, entityCard);
                    unmatchedCards.remove(listEntityCard);
                    continue;
                }
                this.addCard(entityCard);
                continue;
            }
            unmatchedCards.remove(listEntityCard);
            this.replaceCard(listEntityCard, entityCard);
            Card cardByTitle = (Card)cardsByTitle.get(entityCard.getTitle());
            if (cardByTitle == null) continue;
            this.removeCard(cardByTitle);
        }
        for (Card unmatchedCard : unmatchedCards) {
            if (unmatchedCard.getId() == null) continue;
            this.removeCard(unmatchedCard);
        }
        this.resolved = true;
        return this.dirty;
    }

    public Card get(Card card) {
        int ix = this.cards.indexOf(card);
        if (ix >= 0) {
            return this.cards.get(ix);
        }
        return null;
    }

    public void remove(Card card) {
        this.validate();
        this.dirty = this.cards.remove(card) || this.dirty;
    }

    public void add(Card card) {
        this.validate();
        card.validate();
        int ix = this.cards.indexOf(card);
        if (ix >= 0) {
            if (card.getId() == null) {
                this.cards.set(ix, card);
                this.dirty = true;
            }
        } else {
            if (card instanceof ResolvedCard) {
                int i = this.findByTitle(((ResolvedCard)card).getTitle());
                if (i >= 0) {
                    this.cards.set(i, card);
                } else {
                    this.addCard(card);
                }
            } else {
                this.addCard(card);
            }
            this.dirty = true;
        }
    }

    private int findByTitle(String title) {
        int i = 0;
        for (Card card : this.cards) {
            if (card.getId() == null && title.equals(card.makeTitle())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void replace(Card from, Card to) {
        this.validate();
        to.validate();
        int ix = this.cards.indexOf(from);
        if (ix >= 0) {
            this.cards.set(ix, to);
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveBefore(Card before, Card theCard) {
        this.validate();
        theCard.validate();
        if (theCard.equals(before)) {
            return;
        }
        int previousCardIndex = this.cards.indexOf(before);
        int existingCardIndex = this.cards.indexOf(theCard);
        try {
            if (previousCardIndex < 0) {
                if (existingCardIndex < 0) {
                    this.cards.add(theCard);
                } else {
                    Card moved = this.cards.remove(existingCardIndex);
                    this.cards.add(moved);
                }
            } else if (existingCardIndex < 0) {
                this.cards.add(previousCardIndex, theCard);
            } else {
                Card moved = this.cards.remove(existingCardIndex);
                this.cards.add(this.cards.indexOf(before), moved);
            }
        }
        finally {
            this.dirty = true;
        }
    }

    private void removeCard(Card card) {
        if (this.cards.remove(card)) {
            this.dirty = true;
        }
    }

    private void addCard(Card card) {
        this.dirty = true;
        this.cards.add(card);
    }

    private void addCard(int position, Card card) {
        this.dirty = true;
        this.cards.add(position, card);
    }

    private void replaceCard(Card from, Card to) {
        int i = this.cards.indexOf(from);
        this.cards.set(i, to);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public List<ResolvedCard> getResolved() {
        ArrayList<ResolvedCard> resolvedCards = new ArrayList<ResolvedCard>(this.cards.size());
        for (Card card : this.cards) {
            if (card instanceof ResolvedCard) {
                resolvedCards.add((ResolvedCard)card);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)card.getBody())) continue;
            resolvedCards.add(new ResolvedCard(card.getBody()));
        }
        return resolvedCards;
    }

    private void validate() {
        if (this.resolved) {
            throw new IllegalStateException("Cards cannot be manipulated after resolving entities");
        }
    }

    public List<Card> getForStorage() {
        ArrayList<Card> storageCards = new ArrayList<Card>();
        for (Card card : this.cards) {
            if (card instanceof ResolvedCard) {
                Card newCard = ((ResolvedCard)card).toCard();
                storageCards.add(newCard);
                continue;
            }
            storageCards.add(card);
        }
        return storageCards;
    }

    public int size() {
        return this.cards.size();
    }

    public String toString() {
        StringBuilder sB = new StringBuilder();
        for (Card card : this.cards) {
            sB.append(card.toString()).append("\n");
        }
        return sB.toString();
    }

    public Card getCardBefore(NewCard card) {
        int cardIndex = this.cards.indexOf(card);
        if (cardIndex < this.cards.size() - 1) {
            return this.cards.get(cardIndex + 1);
        }
        return null;
    }
}

