/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    if (Canvas.initialized("label.column")) {
        return;
    }

    AJS.toInit(function ($) {
        AJS.log("init label.column");
        $(document).on('change', "#column-label-select", function(event) {
            event.preventDefault();
            var selectedLabel = $("#column-label-select option:selected").val();
            if (selectedLabel.length > 0) {
                $(".field-group.labelname").addClass("existinglabel");
                if ($("#column-header").val() == 0) {
                    $("#column-header").val(selectedLabel);
                    $("#column-header").change();
                }
                $(".field-group.labelname input").val(selectedLabel);
                $(".field-group.labelname input").trigger("keyup");
            } else {
                $(".field-group.labelname input").val("");
                $(".field-group.labelname input").trigger("keyup");
                $(".field-group.labelname").removeClass("existinglabel");
            }
        });

        // Saving column
        $(document).on('click', "form.aui.checklist.column.label .accept", function(event) {
            event.preventDefault();
            var $form = $(this).parents("form.aui.checklist");
            var columnInfo = $form.getColumnInfo();
            columnInfo.setAttributes($form);
            columnInfo.resetHeading();
            // let's set the column's specific properties
            var readonly = $("#readonly:checked").val();
            columnInfo.column[columnInfo.type].readOnly = typeof readonly != 'undefined' ;
            columnInfo.column[columnInfo.type].color = $("#label-color").val() || "";
            if ($("#column-label-select").length > 0) {
                var selectedLabel = $("#column-label-select option:selected").val();
            }
            if (selectedLabel && selectedLabel.length > 0) {
                columnInfo.column[columnInfo.type].labelName = selectedLabel;
            } else if ($("#column-label").val().length > 0 ) {
                var labelName = $("#column-label").val();
                if (Adhoc.common.isValidLabel(labelName) ){
                    columnInfo.column[columnInfo.type].labelName = labelName;
                } else {
                    Adhoc.common.errorMessage($("#column-label").parent(), AJS.I18n.getText("adhoclists.boards.designer.error.invalid-label"), 5000);
                    return false
                }
            } else {
                return false;
            }
            Adhoc.Checklist.columnDialog.hide();
            Adhoc.Checklist.refresh();
        });
    });

})(AJS.$);