/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};
Adhoc.Checklist = {};

(function ($) {
    if (Canvas.initialized("checklists")) {
        return;
    }

    Adhoc.Checklist.empty = function($rowElement) {
        return $rowElement.parents("tr.page").length == 0;
    };

    Adhoc.Checklist.rowId = function($rowElement) {
        return "" + $rowElement.parents("tr.page").attr("pageid");
    };

    Adhoc.Checklist.loadRows = function($trigger) {
        var $moreRows = $trigger.parents("tr.morerows");
        var $checklistTable = $trigger.parents("table.adhocchecklist");
        var $checklistRows = $checklistTable.find("tbody.rows");
        var $checklist = $trigger.parents(".checklistwrapper");
        var filter = new Canvas.Filter($checklist);
        var checklist = $checklist.find(".checklistobject").text();
        var start = $moreRows.attr("start");
        var count = $moreRows.attr("count");
        var currentRowsCount = $checklistRows.find("tr").length;
        var spaceKey = filter.spaceKey;
        $moreRows.addClass("loading");
        var $spinner = $moreRows.find(".morespinner");
        Adhoc.addSmallSpinner($spinner);
        $.ajax({
            type: "POST",
            cache: false,
            data: checklist,
            contentType: "application/json",
            url: Confluence.getContextPath() + "/rest/adhoclists/latest/lists/rows" +
                    "?spaceKey=" + spaceKey +
                    "&start=" + start +
                    "&count=" + count +
                    "&labels=" + filter.allIncludedLabels() +
                    "&parent=" + filter.parentId +
                    "&depth=" + filter.depth
                    ,
            success: function (data, textStatus, jqXHR) {
                $checklistRows.append(data);
                var newCount = $checklistRows.find("tr").length;
                if (newCount > currentRowsCount) {
                    $moreRows.attr("start",newCount);
                } else {
                    $moreRows.addClass("hidden");
                }
                $moreRows.removeClass("loading");
                $spinner.empty();
                $checklistTable.trigger("update");
                $checklistTable.find("th").each(function() {
                    $(this).removeClass("headerSortDown");
                    $(this).removeClass("headerSortUp");
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Adhoc.common.errorHandler($checklist,jqXHR, textStatus,errorThrown);
            }
        });
    };

    Adhoc.Checklist.addRow = function($checklist) {
        var spaceKey = AJS.params.spaceKey;
        var filter = new Canvas.Filter($checklist);
        var parentId;
        if (filter.parentId) {
            parentId = filter.parentId;
        } else if (AJS.params.pageId) {
            parentId = AJS.params.pageId;
        } else {
            parentId = 0;
        }
        var formParams = {
            excerpt: $("textarea.excerptbody").val(),
            checklist: $(".checklistobject",$checklist).text()
        };
        var pageId = parentId;
        var title = $("input.newrowtitle",$checklist).val();
        var $checklistTable = $("table.adhocchecklist",$checklist);
        var $checklistRows = $("table.adhocchecklist tbody.rows",$checklist);
        var $messageTarget = $("tr.newpagerow",$checklist);
        $.ajax({
            type: "POST",
            cache: false,
            data: JSON.stringify(formParams),
            contentType: "application/json",
            url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/" + spaceKey + "/addpage" +
                "?title="+title+
                "&pageId="+pageId+
                "&filterLabels="+filter.labels
            ,
            success: function (data, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    $checklistRows.prepend(data);
                    var $newRow = $("tr:first",$checklistRows);
                    $("tr.newpagerow td",$checklist).trigger("initcell",$newRow);
                    $checklistTable.trigger("update");
                    $checklistTable.find("th").each(function() {
                        $(this).removeClass("headerSortDown");
                        $(this).removeClass("headerSortUp");
                    });
                    $(".addchecklistrow span",$checklist).click();
                } else {
                    Adhoc.common.errorMessage($messageTarget,"error " + jqXHR.status + " txt stusts " + textStatus,2000);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Adhoc.common.errorHandler($messageTarget,jqXHR, textStatus,errorThrown);
            }
        })
    };

    AJS.toInit(function ($) {
        AJS.log("init checklists");
        $("tr.morerows td div").click(function() {
            Adhoc.Checklist.loadRows($(this));
        });
        // making the column labels not sortable
        var i = 0;

        $(".adhocchecklist.view").tablesorter({
            textExtraction: function(node) {
                var $cell = $(node);
                var $sortValue = $cell.find(".sortvalue");
                if ($sortValue.length > 0) {
                    return $sortValue.text();
                } else {
                    return $cell.text();
                }
            }
        });
        // adding rows
        $(document).on('click', ".addchecklistrow span, .canceladdrow", function(event) {
            event.preventDefault();
            var $checklist = $(this).parents(".checklistwrapper");
            Adhoc.common.clearErrorMessage($checklist);
            $("tr.newpage",$checklist).toggleClass("hidden");
            $(".addchecklistrow span",$checklist).toggleClass("hidden");
            $("tr.newpagerow td",$checklist).trigger("resetcell");
            AJS.$("input[name='newrowtitle']").change();
        });
        AJS.$(document).on('change', "input[name='newrowtitle']", function() {
            $(this).parents("thead").find(".acceptaddrow").toggleButton($(this));
        });
        AJS.$(document).on('keyup', "input[name='newrowtitle']", function() {
            $(this).parents("thead").find(".acceptaddrow").toggleButton($(this));
        });
        AJS.$(document).on('click', "input.acceptaddrow", function(event) {
            event.preventDefault();
            var $checklist = $(this).parents(".checklistwrapper");
            Adhoc.Checklist.addRow($checklist);
        });

        $(".labelfilter").click(function(event) {
            event.preventDefault();
            var $dropdown = $(this).closest('.aui-dropdown2');
            var $trigger = $('button[aria-controls=' + $dropdown.attr('id') + ']');
            var $header = $trigger.parents("th");
            var $table = $trigger.parents(".checklistwrapper");
            var filter = new Canvas.Filter($table);
            $header.removeClass("filteron filteroff");
            $dropdown.find(".labelfilter.active").each(function(){
                $(this).removeClass("active");
            });
            var $any = $dropdown.find(".labelfilter.any");
            var label = $(this).attr("label");
            $any.removeAttr("label");
            if ($(this).hasClass("filteron")) {
                $header.addClass("filteron");
                $(this).addClass("active");
                $any.attr("label", label);
                filter.addIncludeLabel(label);
                filter.removeExcludeLabel(label);
            } else if ($(this).hasClass("filteroff")) {
                $header.addClass("filteroff");
                $(this).addClass("active");
                $any.attr("label", label);
                filter.removeIncludeLabel(label);
                filter.addExcludeLabel(label);
            } else {
                filter.removeIncludeLabel(label);
                filter.removeExcludeLabel(label);
            }
            var $moreRows = $("tr.morerows",$table);
            $moreRows.attr("rows","0");
            $moreRows.attr("start","0");
            $("tbody.rows",$table).empty();
            Adhoc.Checklist.loadRows($("tr.morerows td div",$table));
        });
        // if list is empty, let's click the add button
        $(".addchecklistrow.emptylist span").click();

        // Track if at least one checklist is embedded in page
        Canvas.CML.analytics.trackEvent('checklist', 'view');
    });
})(AJS.$);