/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};
Adhoc.Board = Adhoc.Board || {};

(function($){
    Adhoc.Board.notifyOnMoveDontAsk = false;
    Adhoc.Board.notifyOnMove = false;
    var movePageDialog;

    var updateNotifications = function(){
        Adhoc.Board.notifyOnMoveDontAsk = $("#boardnotifications-ask").is(":checked")
    };

    AJS.toInit(function ($) {
        AJS.log("init notifications");
        movePageDialog = null;
        Adhoc.Board.getMovePageDialog = function () {
            if (movePageDialog != null) {
                return movePageDialog;
            }

            var checkbox =  "<div class='checkbox' style='float: left; padding-left: 30px;'>" +
                                "<input name='boardnotifications-ask' id='boardnotifications-ask' type='checkbox'>" +
                                "<label for='boardnotifications-ask'>" +
                                    AJS.I18n.getText('adhoccanvas.notifications.dont.ask.again') +
                                "</label>" +
                            "</div>";
            var message = "<p>" + AJS.I18n.getText("adhoccanvas.other.users.are.watching") + "</p>";
            var content = message + checkbox;
            movePageDialog = new Canvas.CML.Dialog({
                id: "move-notification-dialog",
                size: 'small',
                title: AJS.I18n.getText("adhoccanvas.notification.boards.page.watchers"),
                content: content,
                actions: [
                    {
                        id: 'Yes',
                        style: 'primary',
                        label: AJS.I18n.getText("adhoccanvas.notification.yes"),
                        onClick: function() {
                            Adhoc.Board.notifyOnMove = true;
                            updateNotifications();
                            movePageDialog.hide();
                        }
                    },
                    {
                        id: 'No',
                        style: 'default',
                        label: AJS.I18n.getText("adhoccanvas.notification.no"),
                        onClick: function () {
                            Adhoc.Board.notifyOnMove = false;
                            updateNotifications();
                            movePageDialog.hide();
                        }
                    },
                ]
            });
            return movePageDialog;

        };
    });

})(AJS.$);