/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.rest;

import com.comalatech.confluence.boards.rest.model.NewCard;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public interface BoardResourcesValidator {
    public static final int MAX_CARDS_PER_REQUEST = 100;

    default public boolean isValidPlainCardPayload(NewCard card) {
        return card != null && StringUtils.isNotBlank((CharSequence)card.getBody());
    }

    default public boolean isValidPlainCardsPayload(NewCard[] cards) {
        return cards != null && cards.length <= 100 && Arrays.stream(cards).allMatch(this::isValidCardPayload);
    }

    default public boolean isValidCardsForMoving(NewCard[] cards) {
        if (cards != null) {
            NewCard cardTo;
            NewCard cardFrom = cards[0];
            NewCard newCard = cardTo = cards.length == 2 ? cards[1] : null;
            if (this.isValidCardPayload(cardFrom) && (this.isValidCardPayload(cardTo) || cardTo == null)) {
                return true;
            }
        }
        return false;
    }

    default public boolean isValidCardPayload(NewCard card) {
        return card != null && (StringUtils.isNotBlank((CharSequence)card.getBody()) || StringUtils.isNotBlank((CharSequence)card.getId()));
    }

    default public boolean isValidPageCardPayload(NewCard card) {
        return card != null && StringUtils.isNotBlank((CharSequence)card.getId());
    }

    default public boolean isValidPlainCardsForUpdating(NewCard[] cards) {
        return cards != null && cards.length == 2 && this.isValidPlainCardPayload(cards[0]) && this.isValidCardPayload(cards[1]) && StringUtils.equals((CharSequence)cards[0].getContainerId(), (CharSequence)cards[1].getContainerId());
    }
}

