/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.model;

import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.adhoclists.model.Styles;
import com.opensymphony.util.TextUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="container")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Container {
    private String key;
    private String caption;
    private String style;
    private List<String> cards;
    private String description;
    private String icon;

    protected Container(String key, String caption, String style) {
        this.key = key;
        this.caption = caption;
        this.style = style;
    }

    public Container(String key, String caption) {
        this(key, caption, null);
    }

    public Container(Page page) {
        this(page.getTitle(), page.getTitle());
    }

    public Container() {
        this(null, null);
    }

    public Container(String key) {
        this(key, null);
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getKey() {
        return this.key;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getStyle() {
        return this.style;
    }

    @XmlTransient
    public String getCompositeStyle() {
        return Styles.getCompositeStyle(this.style);
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public List<String> getCards() {
        return this.cards;
    }

    public void setCards(List<String> cards) {
        this.cards = cards;
    }

    @XmlTransient
    public boolean isEmpty() {
        return this.caption == null;
    }

    public boolean hasDetails() {
        return TextUtils.stringSet((String)this.icon) || TextUtils.stringSet((String)this.description);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container container = (Container)o;
        if (this.caption != null ? !this.caption.equals(container.caption) : container.caption != null) {
            return false;
        }
        return !(this.key != null ? !this.key.equals(container.key) : container.key != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.caption != null ? this.caption.hashCode() : 0);
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }
}

