/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.servlet;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAdhocCanvasHttpServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AbstractAdhocCanvasHttpServlet.class);
    private final TemplateRenderer templateRenderer;
    private final LoginUriProvider loginUriProvider;

    public AbstractAdhocCanvasHttpServlet(TemplateRenderer templateRenderer, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(request.getRequestURL().toString())).toASCIIString());
    }

    public abstract void doAction(HttpServletRequest var1, HttpServletResponse var2, AbstractPage var3, ConfluenceUser var4) throws IOException;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        this.doAction(req, resp, null, user);
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, String template, Map<String, Object> context) throws IOException {
        resp.setContentType("text/html; charset=UTF-8");
        resp.addHeader("Access-Control-Allow-Origin", "*");
        resp.addHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
        context.put("resp", resp);
        context.put("req", req);
        context.put("urlMode", UrlMode.AUTO);
        context.put("resourceFilter", new ComalatechWebResourceFilter());
        context.put("scope", Collections.singletonList("com.comalatech.adhoccanvas:canvaspicker"));
        this.templateRenderer.render(template, context, (Writer)resp.getWriter());
    }

    public class ComalatechWebResourceFilter
    implements WebResourceFilter {
        private DefaultWebResourceFilter defaultWebResourceFilter;

        public ComalatechWebResourceFilter() {
            try {
                Constructor constructor = DefaultWebResourceFilter.class.getConstructor(new Class[0]);
                this.defaultWebResourceFilter = (DefaultWebResourceFilter)constructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                try {
                    Constructor constructor = DefaultWebResourceFilter.class.getConstructor(Boolean.TYPE);
                    this.defaultWebResourceFilter = (DefaultWebResourceFilter)constructor.newInstance(false);
                }
                catch (Exception e2) {
                    log.error("There was a problem trying to provide forward compatibility with Confluence 7", (Throwable)e2);
                }
            }
        }

        public boolean matches(String resourceName) {
            return resourceName.contains("com.comalatech") && this.defaultWebResourceFilter.matches(resourceName);
        }
    }
}

