/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.listeners;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.event.events.plugin.PluginEvent;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class PluginInstalledListener
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PluginInstalledListener.class);
    private static final String METADATA_LISTENER_MODULE_KEY = "org.andya.confluence.plugins.metadata:metadataPageUpdateListener";
    public static final String UNSAFE_KEY = "org.andya.confluence.plugins.metadata.unsafe";
    private PluginAccessor pluginAccessor;
    private PluginController pluginController;
    private EventPublisher eventPublisher;
    private BandanaManager bandanaManager;

    public PluginInstalledListener(PluginAccessor pluginAccessor, PluginController pluginController, EventPublisher eventPublisher, BandanaManager bandanaManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
        this.eventPublisher = eventPublisher;
        this.bandanaManager = bandanaManager;
        this.makeClearingMetadataUnsafe();
        this.checkMetadataPluginListener();
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void handlePluginEvent(PluginEvent event) {
        this.checkMetadataPluginListener();
    }

    private void checkMetadataPluginListener() {
        if (this.pluginAccessor.isPluginModuleEnabled(METADATA_LISTENER_MODULE_KEY)) {
            try {
                log.error("Metadata plugin listener enabled. Disabling. See https://studio.plugins.atlassian.com/browse/APRV-333");
                this.pluginController.disablePluginModule(METADATA_LISTENER_MODULE_KEY);
            }
            catch (Exception e) {
                log.error("Could not disable Metadata plugin listener. Please disable Manually", (Throwable)e);
            }
        }
    }

    private void makeClearingMetadataUnsafe() {
        log.info("making sure sure metadata plugin does not clear data...");
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), UNSAFE_KEY, (Object)true);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

