/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs; 

requirejs(['jquery', 'ajs', 'confluence/root'], function ($, AJS, ConfluenceRoot) {
    var Canvas = Canvas || {};

    var boardGalleryDialog;

    var boardMacroOpener = function(macro) {
        var filterParams = Adhoc.filter.getFilterParams( macro );
        var parent;

        if (macro && macro.body && macro.body.length > 1) {
            console.log('edit mode')
            Adhoc.Board.setMacroParams( macro );
            $("#macro-browser-preview").html(""); // need to remove whatever preview was rendered

            var url = ConfluenceRoot.getContextPath() + "/rest/adhoclists/latest/boards/" +
                    (AJS.params.contentId || "0").toString() + "/edit" +
                    "?id=" + Adhoc.Board.getIdParam() +
                    "&parent=" + filterParams.parent +
                    "&filterspacekey=" + filterParams.spacekey +
                    "&labels=" + filterParams.labels +
                    "&depth=" + filterParams.depth +
                    "&allSpaces=" + filterParams.allSpaces;
            $.ajax({type:"POST",
                cache:false,
                data: macro.body,
                contentType: "application/json; charset=utf-8",
                url:url,
                success:function (html, textStatus, jqXHR) {
                    var boardDesignerDialog = new Canvas.CML.Dialog({
                        id: "boardDesigner",
                        width: 1024,
                        height: 530,
                        title: AJS.I18n.getText("adhoclists.rte.boards.edit"),
                        content: html,
                        open: true,
                        remove: true,
                        actions: [
                            {
                                id: 'save',
                                style: 'primary save-board',
                                label: AJS.I18n.getText("save.name")
                            },
                            {
                                id: 'cancel',
                                style: 'link cancel-insert-board',
                                label: AJS.I18n.getText("cancel.name")
                            },
                        ],
                        onOpen: function() {
                            Adhoc.initDesignBoard();
                            Adhoc.filter.init();
                            // We explicitly initialize the tabs
                            AJS.tabs.setup();
                            AJS.tabs.change(AJS.$("a[href=#edit-board-board]"));
                            // prepend in dialog title
                            $('#boardDesigner .aui-dialog2-header').append(Adhoc.common.feedbackFormLink('m7x1p5'));
                        }
                    });
                    
                    var $content = boardDesignerDialog.getContent();
                    ConfluenceRoot.Binder.autocompletePage($content);
                    ConfluenceRoot.Binder.autocompleteSpace($content);
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    clearBoardDialogs();

                    // Disable fadeOut so that the "cancel" button does not disappear and the dialog can be closed
                    Adhoc.common.errorHandlerFadeOut($content,jqXHR, textStatus,errorThrown, false);
                }
            });
        } else {
            if (macro && macro.params) {
                Canvas.filter = makeFilter(macro.params);
            } else {
                delete Canvas['filter'];
            }
            boardGalleryDialog.show();    
            // prepend in dialog title
            $('#boardPicker .aui-dialog2-header').prepend(Adhoc.common.feedbackFormLink('m7x1p5'));
        }
    };

    var makeFilter = function(parameters) {
        var filter;
        if (parameters.labels && parameters.labels.length > 0) {
            filter = filter || {};
            filter.labels = parameters.labels;
        }
        if (parameters.allSpaces && parameters.allSpaces) {
            filter = filter || {};
            filter.allSpaces = parameters.allSpaces;
        }
        if (parameters.spacekey && parameters.spacekey.length > 0) {
            filter = filter || {};
            filter.spaceKey = parameters.spacekey;
        }
        if (parameters.parent && parameters.parent.length > 0) {
            filter = filter || {};
            filter.parent = parameters.parent;
        }
        if (parameters.depth && parameters.depth > 0) {
            filter = filter || {};
            filter.depth = parameters.depth;
        }

        return filter;
    };

    var makeUpdateMacroRequest = function () {
        Adhoc.Board.update();
        var request = {
            contentId:ConfluenceRoot.Editor.getContentId(),
            macro:{
                name:"adhocboard",
                body:Adhoc.Board.toJson(),
                params:{
                    name: Adhoc.Board.board.name
                }
            }
        };
        var id = Adhoc.Board.getIdParam( );
        if ( id.length ){
            request.macro.params.id = id;
        }
        Adhoc.filter.setFilterMacroParams(request);
        return request;
    };

    var bindDialogActions = function() {
        $(document).on('click', ".cancel-insert-board", Canvas.CML.closeDialogs);
        $(document).on('click', ".save-board", function(event) {
            event.preventDefault();
            Canvas.CML.analytics.trackEvent('board', 'edit');
            var t = tinymce.confluence.macrobrowser;
            var macroRenderRequest = makeUpdateMacroRequest();
            AJS.Rte.BookmarkManager.restoreBookmark();
            tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest, t.editedMacroDiv);
            Canvas.CML.closeDialogs();
        });

        // for some bloody reason, the aui tabs don't work on a macro-brower panel :-(
            $(document).on('click', ".cnv-brd-tabs-edit li.menu-item a", function(event) {
            event.preventDefault();
            var tabs = $(this).parents(".aui-tabs");
            tabs.find(".menu-item").removeClass("active-tab");
            $(this).parents("li").addClass("active-tab");
            tabs.find(".tabs-pane").removeClass("active-pane");
            $($(this).attr("href")).addClass("active-pane");
        });
    };


    var closeBoardGallery = function() {
        boardGalleryDialog.hide();
    };

    var selectGalleryBoard = function(event,selection) {
        var macroRequest = makeGalleryMacroRequest(selection.table,selection.filter);
        if (selection.id == 0) {
            boardGalleryDialog.hide();
            boardMacroOpener(macroRequest.macro);
        } else {
            AJS.Rte.BookmarkManager.restoreBookmark();
            var t = tinymce.confluence.macrobrowser;
            tinymce.confluence.MacroUtils.insertMacro(macroRequest, t.editedMacroDiv);
            boardGalleryDialog.hide();
        }
    };

    var makeGalleryMacroRequest = function (board,filter) {
        return {
            contentId:ConfluenceRoot.Editor.getContentId(),
            macro: makeMacro(board,filter)
        }
    };

    var makeMacro = function(board,filter) {
        macro = {
            name: "adhocboard",
            body: JSON.stringify(board),
            params:{
                name:board.name
            }
        };
        if (filter.labels) {
            macro.params.labels = filter.labels;
        }
        if (filter.allSpaces) {
            macro.params.allSpaces = filter.allSpaces;
        }
        if (filter.spaceKey) {
            macro.params.spaceKey = filter.spaceKey;
        }
        if (filter.parent) {
            macro.params.parent = filter.parent;
        }
        if (filter.depth > 0) {
            macro.params.depth = filter.depth;
        }
        return macro;
    };

    AJS.bind("init.rte", function() {
        AJS.log("init boards-rte");
        var $ = AJS.$;
        
        boardGalleryDialog = new Canvas.CML.Dialog({
            id: "boardPicker",
            width: 840,
            height: 481,
            // size: 'large',
            // title: 'Board Picker',
            path: '/picker',
            query: {
                spaceKey: AJS.params.spaceKey
            }
        });
        AJS.MacroBrowser.setMacroJsOverride("adhocboard", {opener: boardMacroOpener});

        $(document).on('change', "select.macro-param-input", function(event) {
            var macroName = $("#macro-insert-container").find(".macro-name").val();
            if (macroName == "space-board") {
                $("#macro-browser-preview-link").click();
            }
        });
        bindDialogActions();

        // 1.4
        $(document).delegate("iframe.canvas","canvas.close",closeBoardGallery);
        $(document).delegate("iframe.canvas","canvas.select",selectGalleryBoard);

    });

})

