/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Adhoc = Adhoc || {};
Adhoc.filter = Adhoc.filter || {};
var Canvas = Canvas || {};

Adhoc.switchFilterGroup = function(allSpaces) {
    if ($(allSpaces).is(':checked')) {
        $('.main-filter').attr('readonly', true);
    } else {
        $('.main-filter').attr('readonly', false);
    }
};

// This functions are to be used ONLY FOR THE DESIGNERS
// see filters.js for handing filters while rendering boards/lists
(function ($) {
    if (Canvas.initialized("filters")) {
        return;
    }

    Adhoc.filter.labelsList = function() {
        return toList(Adhoc.filter.labels);
    };

    Adhoc.filter.load = function() {
        Adhoc.filter.labels = [];
        var labelsList = AJS.params.adhocFilterLabels;
        if (! labelsList) {
            return;
        }
        Adhoc.filter.labels = labelsList.split(",");
    };

    Adhoc.filter.parent = function(){
        var parent = $("#checklistparent").val();
        if ( parent != "" )
            return parent;
        return "";
    };

    Adhoc.filter.allSpaces = function() {
        if ($('#allSpaces').is(':checked')) {
            return true;
        } else {
            return false;
        }

    };

    Adhoc.filter.spacekey = function(){
        var $spaceKey = $("#adhocFilterSpaceKey");
        var spacekey = $spaceKey.val();
        if ( spacekey != "" )
            return spacekey;
        return "";
    };

    Adhoc.filter.depth = function() {
        var depth = $("#adhocFilterDepth.filterinput").val() || 0;
        return depth;
    };

    Adhoc.filter.getFilterParams = function(macro) {
        var params = {
            labels: "",
            allSpaces: false,
            parent: "",
            spacekey: "",
            depth: ""
        };
        if (macro && macro.params) {
            if (macro.params.allSpaces) {
                params.allSpaces = macro.params.allSpaces;
            }
            if (macro.params.labels) {
                params.labels = macro.params.labels;
            }
            if (macro.params.parent) {
                params.parent = macro.params.parent;
            }
            if (macro.params.spacekey) {
                params.spacekey = macro.params.spacekey;
            }
            if ( macro.params.depth ){
                params.depth = macro.params.depth;
            }
        }
        return params;
    };

    Adhoc.filter.setFilterMacroParams = function(request) {
        if (Adhoc.filter.labelsList().length > 0) {
            request.macro.params.labels = Adhoc.filter.labelsList();
        }
        if (Adhoc.filter.allSpaces()) {
            request.macro.params.allSpaces = Adhoc.filter.allSpaces();
        }
        if (Adhoc.filter.parent().length > 0) {
            request.macro.params.parent = Adhoc.filter.parent();
        }
        if (Adhoc.filter.spacekey().length > 0) {
            request.macro.params.spacekey = Adhoc.filter.spacekey();
        }
        var depth = Adhoc.filter.depth();
        if (depth.length > 0 && depth > 0 ){
            request.macro.params.depth = depth;
        }

    };


    var toList = function (labelFilter) {
        if (!labelFilter) {
            return "";
        }
        var list = "";
        var separator = "";
        for (var i = 0; i < labelFilter.length; i++) {
            list = list + separator + labelFilter[i];
            separator = ",";
        }
        return list;
    };

    var addLabel = function(label) {
        $("#filterlabels li[name='" + label + "']").remove();
        $("#filterlabels").append("<li name='" + label + "'>" + label +"<a class='remove-label' title='Delete'>Delete</a></li>");
        $("#filterlabelsstring").val("");
        $("#suggested-" + label).remove();
        $("#filterlabels").trigger("adhoc.update");
    };

    Adhoc.filter.init = function() {
        Adhoc.switchFilterGroup($('input#allSpaces'));

        $("#filterlabelsstring").quicksearch("/labels/autocompletelabel.action",
                function() {},
                {
                    makeParams: function(val) {
                        return {
                           query: val,
                           contentId: ""
                        };
                    },
                    dropdownPlacement: function (dropDown) {
                       $("#labelsAutocompleteList").append(dropDown);
                    },
                    ajsDropDownOptions : {
                        selectionHandler: function (e, selection) {
                            var span = $("span", selection);
                            var contentProps = $.data(span[0], "properties");
                            var label = contentProps.name;
                            addLabel(label);
                            this.hide();
                            e.preventDefault();
                        }
                    }
               }
        );
        // first we try to get the filter from the AJS params...
        Adhoc.filter.load();
        // then, lets trigger an update of there is a filter form
        $("#filterlabels").trigger("adhoc.update");
    };

    AJS.toInit(function ($) {
        AJS.log("init filter");
        $(document).on('click', "#adhocfilter .suggested-label", function(event) {
            event.preventDefault();
            addLabel($(this).text());
        });

        $(document).on('click', "#adhocfilter .editfilterlabels", function (event) {
            event.preventDefault();
            // don't grab labels when hiding
            if ($("#adhocfilter .labelsdialog:visible").length) {
                $("#adhocfilter .labelsdialog").toggleClass("hidden");
                $("#adhocfilter fieldset.labels").toggleClass("edit");
                return;
            }
            var $suggestedLabels = $(this).parent().find("#suggestedLabelsSpan .container");
            var spaceKey = Adhoc.filter.spacekey() || AJS.params.spaceKey;
            // show what we've got
            $("#adhocfilter .labelsdialog").toggleClass("hidden");
            $("#adhocfilter fieldset.labels").toggleClass("edit");
            Adhoc.common.getSuggestedLabels(spaceKey, function (data) {
                $suggestedLabels.empty();
                $.each(data, function (index, value) {
                    $suggestedLabels.append(
                        AJS.template.load(Adhoc.sanitizeBoardContent('suggested-label').fill({suggestedLabel:value.name}).toString())
                    );
                });
            });
        });

        $(document).on('click', "#filterlabels li a", function(event) {
            event.preventDefault();
            $(this).parents("li").remove();
            $("#filterlabels").trigger("adhoc.update");
        });

        $(document).on('click', "#add-filter-label", function(event) {
            event.preventDefault();
            // todo validate label
            var label = $("#filterlabelsstring").val();
            if (label && label.length > 0) {
                addLabel(label);
                $("#filterlabelsstring").val("");
            }
        });
        
        $(document).on('click', "#done-filter-label", function(event) {
            event.preventDefault();
            $("#adhocfilter .editfilterlabels").click();
        });

        $(document).on('adhoc.update', "#filterlabels", function() {
            Adhoc.filter.labels = [];
            $("#filterlabels li").each(function() {
                Adhoc.filter.labels.push($(this).attr("name"));
            });
            if (Adhoc.filter.labels.length  > 0) {
                $("fieldset.labels .description").removeClass("hidden");
            } else {
                $("fieldset.labels .description").addClass("hidden");
            }
        });

        var updateSpaceKey = () => {
            setTimeout(() => {
                var spacekey = Adhoc.filter.spacekey();
                if ( spacekey.length > 0 ){
                    $("input#checklistparent").attr("data-spacekey", spacekey);
                    AJS.log("changed data-spacekey to " + spacekey );
                    Confluence.Binder.autocompletePage(  );
                }
            }, 100);
        };

        $(document).on('focusout', "input#adhocFilterSpaceKey", updateSpaceKey);

        $(document).on('change', "input#allSpaces", function () {
            Adhoc.switchFilterGroup(this);
        });

        Adhoc.filter.init();
     });
})(AJS.$);