/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;

requirejs(
    ['cb', 'jquery', 'blueprint-picker'],
    function (CB, $, Picker) {
        CB.toInit(function () {
            var adg3 = CB.getVersion() > 6 ? '-adg3' : '';
            var blueprints = {
                picker: '/boards/picker/blueprint/{0}',
                tasks: '/boards/picker/blueprint/{0}/tasks'
            };
            $.each(Object.keys(blueprints), function(i, bp) {
                CB.Confluence.Blueprint.register(
                    'com.comalatech.adhoccanvas:canvas-blueprint-' + bp + '-webitem' + adg3,
                    new Picker(bp, blueprints[bp])
                );
            });
        });
    }
);