/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.service;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.PlainTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.boards.BoardCreator;
import com.comalatech.confluence.adhoclists.cards.CardManager;
import com.comalatech.confluence.adhoclists.cards.model.Card;
import com.comalatech.confluence.adhoclists.cards.model.Cards;
import com.comalatech.confluence.adhoclists.cards.model.ResolvedCard;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.adhoclists.storage.BoardManager;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import com.comalatech.confluence.boards.macro.BoardMacroParameters;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.BoardViewContext;
import com.comalatech.confluence.boards.renderer.BoardExportRenderer;
import com.comalatech.confluence.boards.rest.model.NewCard;
import com.comalatech.confluence.boards.service.BoardExportService;
import com.comalatech.confluence.boards.service.BoardService;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoardExportServiceImpl
implements BoardExportService {
    private static final Logger log = LoggerFactory.getLogger(BoardExportServiceImpl.class);
    private final BoardManager boardManager;
    private final BoardExportRenderer boardExportRenderer;
    private final FilterManager filterManager;
    private final PermissionManager permissionManager;
    private final BoardCreator boardCreator;
    private final CardManager cardManager;
    private final PageManager pageManager;
    private final GlobalConfigManager globalConfigManager;
    private final AdhocLicenseManager licenseManager;
    private final XhtmlContent xhtmlContent;
    private final BoardService boardService;

    @Autowired
    public BoardExportServiceImpl(BoardManager boardManager, BoardExportRenderer boardExportRenderer, FilterManager filterManager, @ComponentImport PermissionManager permissionManager, BoardCreator boardCreator, CardManager cardManager, @ComponentImport PageManager pageManager, GlobalConfigManager globalConfigManager, AdhocLicenseManager licenseManager, @ComponentImport XhtmlContent xhtmlContent, BoardService boardService) {
        this.boardManager = boardManager;
        this.boardExportRenderer = boardExportRenderer;
        this.filterManager = filterManager;
        this.permissionManager = permissionManager;
        this.boardCreator = boardCreator;
        this.cardManager = cardManager;
        this.pageManager = pageManager;
        this.globalConfigManager = globalConfigManager;
        this.licenseManager = licenseManager;
        this.xhtmlContent = xhtmlContent;
        this.boardService = boardService;
    }

    @Override
    public String renderBoard(BoardMacroParameters params) throws MacroException {
        Board board = this.getBoard(params);
        BoardViewContext viewContext = this.makeBoardViewContext(params, board);
        try {
            viewContext.setPage(params.getAbstractPage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResolvedFilter filter = this.filterManager.resolve(params.filter, viewContext);
        if (params.preview) {
            return this.boardExportRenderer.renderPreview(viewContext, board, filter);
        }
        if (board.isCardsOnlyBoard()) {
            viewContext.setCardsOnly();
        } else if (board.isPagesOnlyBoard()) {
            viewContext.setPagesOnly();
        }
        return this.boardExportRenderer.renderEmbedded(viewContext, board, filter);
    }

    protected Board getBoard(BoardMacroParameters parameters) throws MacroException {
        Board board;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{parameters.body})) {
            board = (Board)this.boardManager.parseJson(parameters.body);
            if (board == null) {
                throw new MacroException("Error parsing board " + parameters.name);
            }
        } else {
            board = (Board)this.boardManager.get(parameters.spaceKey, parameters.name);
            if (board == null) {
                board = (Board)this.boardManager.get(parameters.name);
            }
            if (board == null && ConfluenceActionSupport.getTextStatic((String)"title.labels.popular").equals(parameters.name)) {
                board = this.boardCreator.createPopularLabelsBoard(parameters.spaceKey);
            }
        }
        if (board == null) {
            throw new MacroException("board '" + parameters.name + "' does not exist");
        }
        return board;
    }

    private BoardViewContext makeBoardViewContext(BoardMacroParameters params, Board board) {
        BoardViewContext boardViewContext = new BoardViewContext(params.spaceKey, board.getAllKeys());
        int max = AdhocListsUtils.retrieveMaximumRowsForBoard(this.globalConfigManager, board.getMaxRows(), this.licenseManager.isLicensed());
        boardViewContext.setCount(max);
        List<String> supportedExportFormats = Arrays.asList(SUPPORTED_EXPORT_FORMATS);
        if (supportedExportFormats.contains(params.outputType)) {
            boardViewContext.setPageExport(true);
        }
        boardViewContext.setHostPageIncluded(params.hostPageIncluded);
        this.setViewPermissions(boardViewContext, params);
        return boardViewContext;
    }

    private void setViewPermissions(BoardViewContext viewContext, BoardMacroParameters parameters) {
        if (parameters.readOnly || viewContext.getPage() == null) {
            viewContext.setReadOnly(true);
            return;
        }
        viewContext.setReadOnly(AuthenticatedUserThreadLocal.get() == null || !this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)viewContext.getPage()) || !this.licenseManager.isLicensed());
    }

    @Override
    public void importMarkupCards(BoardMacroParameters parameters, ContentEntityObject contentEntity) throws MacroException {
        Board board = this.getBoard(parameters);
        Map<String, List<ResolvedCard>> cardsFromMarkup = this.cardManager.getAllPredefinedCards(contentEntity, board);
        if (contentEntity == null || contentEntity.getId() == 0L || !(contentEntity instanceof AbstractPage) || !contentEntity.isLatestVersion() || cardsFromMarkup.isEmpty()) {
            return;
        }
        Map<String, Cards> existingCards = this.cardManager.getAllExistingCards(contentEntity, board);
        for (String containerKey : cardsFromMarkup.keySet()) {
            final Cards plainCards = existingCards.get(containerKey);
            Iterable cardsToAdd = Iterables.filter((Iterable)cardsFromMarkup.get(containerKey), (Predicate)new Predicate<ResolvedCard>(){

                public boolean apply(ResolvedCard markupCard) {
                    if (plainCards != null) {
                        for (Card pageCard : plainCards.getForStorage()) {
                            Page p;
                            if (pageCard.getBody() != null && pageCard.makeTitle().equals(markupCard.getTitle())) {
                                return false;
                            }
                            if (pageCard.getId() == null || !(p = BoardExportServiceImpl.this.pageManager.getPage(Long.valueOf(pageCard.getId()).longValue())).getTitle().equals(markupCard.getTitle())) continue;
                            return false;
                        }
                    }
                    return true;
                }
            });
            NewCard[] newCardsToAdd = StreamSupport.stream(cardsToAdd.spliterator(), false).map(it -> new NewCard(it.getId(), it.getBody(), containerKey)).collect(Collectors.toList()).toArray(new NewCard[0]);
            if (newCardsToAdd.length <= 0) continue;
            this.boardService.addPlainCardsToBoard((AbstractPage)contentEntity, newCardsToAdd);
        }
        try {
            board.clear();
            parameters.body = this.boardManager.serializeJson(board);
            AbstractPage abstractPage = this.pageManager.getAbstractPage(contentEntity.getId());
            String body = this.xhtmlContent.updateMacroDefinitions(abstractPage.getBodyAsString(), (ConversionContext)new DefaultConversionContext((RenderContext)abstractPage.toPageContext()), (MacroDefinitionUpdater)new BoardMacroDefinitionUpdater(parameters));
            abstractPage.setBodyAsString(body);
            DefaultSaveContext saveContext = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(true)).updateLastModifier(false).suppressEvents(true)).build();
            this.pageManager.saveContentEntity((ContentEntityObject)abstractPage, (SaveContext)saveContext);
        }
        catch (XhtmlException e) {
            log.error("Could not remove cards from the markup in board " + parameters.name, (Throwable)e);
        }
    }

    private class BoardMacroDefinitionUpdater
    implements MacroDefinitionUpdater {
        private BoardMacroParameters parameters;

        public BoardMacroDefinitionUpdater(BoardMacroParameters parameters) {
            this.parameters = parameters;
        }

        public MacroDefinition update(MacroDefinition macroDefinition) {
            if (macroDefinition.getName().equals("adhocboard") && macroDefinition.getMacroId().isDefined() && ((MacroId)macroDefinition.getMacroId().get()).getId().equals(this.parameters.macroId)) {
                macroDefinition.setBody((MacroBody)new PlainTextMacroBody(this.parameters.body));
            }
            return macroDefinition;
        }
    }
}

