/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.listeners;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.adhoclists.analytics.BoardsAnalyticsManager;
import com.comalatech.confluence.adhoclists.boards.events.AdhocListViewEvent;
import com.comalatech.confluence.adhoclists.boards.events.BoardDesignerOpenedEvent;
import com.comalatech.confluence.adhoclists.boards.events.BoardPageCreatedEvent;
import com.comalatech.confluence.adhoclists.boards.events.BoardViewEvent;
import com.comalatech.confluence.adhoclists.boards.events.CardCreatedEvent;
import com.comalatech.confluence.adhoclists.boards.events.CardUpdatedEvent;
import com.comalatech.confluence.adhoclists.boards.events.ListCustomSpaceListViewEvent;
import com.comalatech.confluence.adhoclists.boards.events.ListPageCreatedEvent;
import com.comalatech.confluence.adhoclists.boards.events.MetadataKeySentEvent;
import com.comalatech.confluence.adhoclists.boards.events.SpaceLastAccessEvent;
import com.comalatech.confluence.adhoclists.boards.events.TaskCardUsedEvent;
import com.comalatech.confluence.adhoclists.boards.events.WatcherNotificationSentEvent;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import org.springframework.beans.factory.DisposableBean;

public class BoardsStatsListener
implements DisposableBean {
    private final GlobalConfigManager globalConfigManager;
    private final EventPublisher eventPublisher;
    private final BoardsAnalyticsManager boardsAnalyticsManager;
    private final AccessModeService accessModeService;

    public BoardsStatsListener(GlobalConfigManager globalConfigManager, EventPublisher eventPublisher, BoardsAnalyticsManager boardsAnalyticsManager, AccessModeService accessModeService) {
        this.globalConfigManager = globalConfigManager;
        this.eventPublisher = eventPublisher;
        this.boardsAnalyticsManager = boardsAnalyticsManager;
        this.accessModeService = accessModeService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onSpaceLastAccess(SpaceLastAccessEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.spacelastaccess");
    }

    @EventListener
    public void onBoardView(BoardViewEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestBoardViewed");
    }

    @EventListener
    public void onAdhocListView(AdhocListViewEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestListViewed");
    }

    @EventListener
    public void onCardCreated(CardCreatedEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestCardCreated");
    }

    @EventListener
    public void onCardUpdated(CardUpdatedEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestCardUpdated");
    }

    @EventListener
    public void onBoardPageCreated(BoardPageCreatedEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestBoardPageCreated");
    }

    @EventListener
    public void onBoardDesignerOpened(BoardDesignerOpenedEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestBoardDesignerOpened");
    }

    @EventListener
    public void onTaskCardUsed(TaskCardUsedEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestTaskCardUsed");
    }

    @EventListener
    public void onListPageCreated(ListPageCreatedEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestListPageCreated");
    }

    @EventListener
    public void onListCustomSpaceListViewed(ListCustomSpaceListViewEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestCustomSpaceListViewed");
    }

    @EventListener
    public void onWatcherNotificationSent(WatcherNotificationSentEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestWatcherNotificationSent");
    }

    @EventListener
    public void onMetadataSentKey(MetadataKeySentEvent event) {
        this.setTimestampAnalyticsEntry("com.comalatech.adhoccanvas.analytics.latestMetadataSet");
    }

    private void setTimestampAnalyticsEntry(String key) {
        if (!this.globalConfigManager.loadGlobalConfig().isNoStats() && !this.accessModeService.isReadOnlyAccessModeEnabled()) {
            this.boardsAnalyticsManager.setTimestampAnalyticsEntry(key);
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

