/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.cards.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

@XmlRootElement(name="card")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Card
implements Serializable {
    private static final long serialVersionUID = 781731606973212598L;
    private String id;
    private String body;

    public Card(String id, String body) {
        this.id = id;
        if (id == null) {
            this.body = this.escape(this.trimBody(body));
            if (this.body == null) {
                throw new IllegalArgumentException("Card must have either an id or a body");
            }
        } else if (body != null) {
            throw new IllegalArgumentException("Card cannot have both and id and a body");
        }
    }

    private String trimBody(String body) {
        if (body == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] lines = body.trim().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(lines[i]);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public Card() {
    }

    public Card(Card card) {
        this.id = card.id;
        this.body = card.body;
    }

    public void validate() {
        if (this.id == null && this.body == null) {
            throw new IllegalArgumentException("Card must have an id and/or a body");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Card)) {
            return false;
        }
        Card card = (Card)o;
        if (this.id != null) {
            return this.id.equals(card.id);
        }
        return this.body.equals(card.body);
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return 31 * this.body.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = this.escape(this.trimBody(body));
    }

    @XmlTransient
    public String makeTitle() {
        if (this.body == null) {
            throw new IllegalStateException("body should not be null");
        }
        return this.body.split("\n")[0].trim();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Cards{");
        String separator = "";
        if (this.id != null) {
            sb.append("id='").append(this.id).append("'");
            separator = ", ";
        }
        if (this.body != null) {
            sb.append(separator).append("body='").append(this.body).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    protected String escape(String content) {
        if (content != null) {
            PolicyFactory policy = new HtmlPolicyBuilder().allowElements("a").allowUrlProtocols("https").allowAttributes("href").onElements("a").requireRelNofollowOnLinks().toFactory();
            return policy.sanitize(content);
        }
        return null;
    }
}

