/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.view.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.adhoclists.boards.view.model.RenderedCard;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import com.comalatech.confluence.boards.model.Container;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.List;

public class ResolvedContainer
extends Container {
    private static final List<RenderedCard> EMPTY = Collections.emptyList();
    private String id;
    private String url;
    private Page page;
    private List<RenderedCard> entities;
    private boolean hasMoreEntities;
    private String descriptionHtml;
    private String moveCaption;
    private int width;
    private int height;

    public ResolvedContainer(Container container, String id, String url, List<RenderedCard> entities) {
        super(container.getKey(), container.getCaption(), container.getStyle());
        this.id = id;
        this.url = url;
        this.entities = entities;
        if (TextUtils.stringSet((String)container.getIcon())) {
            this.setIcon(container.getIcon());
        }
    }

    public ResolvedContainer(Container container) {
        this(container, container.getKey(), null, EMPTY);
        this.setDescription(container.getDescription());
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public List<Label> getLabels() {
        return AdhocListsUtils.toLabelList(this.getKey());
    }

    public void setEntities(List<RenderedCard> entities) {
        this.entities = entities;
    }

    public List<RenderedCard> getEntities() {
        return this.entities;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isHasMoreEntities() {
        return this.hasMoreEntities;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getMoveCaption() {
        return this.moveCaption;
    }

    public void setMoveCaption(String moveCaption) {
        this.moveCaption = moveCaption;
    }

    public void setHasMoreEntities(boolean hasMoreEntities) {
        this.hasMoreEntities = hasMoreEntities;
    }

    public String getCssClass() {
        return "container-" + this.id.replaceAll("[^A-Za-z0-9_\\-]", "");
    }

    public void setDescriptionHtml(String descriptionHtml) {
        this.descriptionHtml = descriptionHtml;
    }

    public String getDescriptionHtml() {
        return this.descriptionHtml;
    }
}

