/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.analytics.web;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.comalatech.confluence.adhoclists.analytics.web.WebAnalyticsManager;
import com.comalatech.confluence.analytics.AnalyticsManager;

public class MatomoWebAnalyticsManagerImpl
implements WebAnalyticsManager {
    private static final String DEV_UA = "16";
    private static final String PROD_UA = "17";
    private static final String MATOMO_DOMAIN = "comalatech.matomo.cloud";
    private AnalyticsManager analyticsManager;
    private PluginLicenseManager licenseManager;

    public MatomoWebAnalyticsManagerImpl(AnalyticsManager analyticsManager, PluginLicenseManager licenseManager) {
        this.analyticsManager = analyticsManager;
        this.licenseManager = licenseManager;
    }

    @Override
    public String getUAKey() {
        if (this.isProdInstance()) {
            return PROD_UA;
        }
        return DEV_UA;
    }

    @Override
    public String getAnalyticsDomain() {
        return MATOMO_DOMAIN;
    }

    @Override
    public boolean isStatsEnabled() {
        return this.analyticsManager.isEnabled();
    }

    private boolean isProdInstance() {
        return !this.analyticsManager.isDevMode() && this.isValidLicense();
    }

    private boolean isValidLicense() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return pluginLicense.isValid() || pluginLicense.isEvaluation();
        }
        return false;
    }
}

