/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};
Adhoc.Checklist = Adhoc.Checklist || {};

Adhoc.debug = {};
Adhoc.debug2 = {};
var requirejs = require || requirejs;

requirejs(['cb', 'jquery'], function (CB, $) {
    if (Canvas.initialized("checklist.designer")) {
        return;
    }

    var saveChecklist = function() {
        Adhoc.Checklist.update();
        var labels = Adhoc.filter.labelsList();
        var parent = Adhoc.filter.parent();
        var depth = Adhoc.filter.depth();
        $.ajax({
            type: "POST",
            cache: false,
            data: Adhoc.Checklist.toJson(),
            contentType: "application/json",
            url: CB.contextPath + "/rest/adhoclists/latest/lists/" +
                    Adhoc.Checklist.spaceKey + "/save" +
                "?labels="+labels+
                "&parent="+parent+
                "&depth="+depth
            ,
            success: function (data, textStatus, jqXHR) {
                window.location = $(".savechecklist").attr("href") + "&name=" + Adhoc.Checklist.checklist.name;
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Adhoc.common.errorHandler($(".checklistwrapper"),jqXHR, textStatus,errorThrown);
            }
        });
    };

    Adhoc.Checklist.moveColumn = function ($columnHeader) {
        var $checklist = $columnHeader.parents("table.adhocchecklist");
        var cols = $checklist.find("tr.headings th").length;
        if (cols == 1) {
            return;
        }
        var ix = Adhoc.Checklist.getColumnIndex($columnHeader, $checklist);
        if (ix < cols-1) {
            moveCellsRight($checklist.find("tr.headings"),ix,"th.heading");
            moveCellsRight($checklist.find("tbody.rows tr"),ix,"td");
        } else {
            Adhoc.Checklist.moveCellsToFirstColumn($checklist.find("tr.headings"),ix,"th.heading");
            Adhoc.Checklist.moveCellsToFirstColumn($checklist.find("tbody.rows tr"),ix,"td");
        }

    };

    Adhoc.Checklist.addColumn = function ($columnHeader) {
        var $checklist = $columnHeader.parents("table.adhocchecklist");
        var ix = Adhoc.Checklist.getColumnIndex($columnHeader, $checklist);

        var cols;
        var $newColumn;
        $checklist.find("tr.headings").each(function() {
            cols = jQuery(this).children("th.heading");
            $newColumn = cols.eq(ix).clone().insertAfter(cols.eq(ix));
        });
        $checklist.find("tbody.rows tr").each(function() {
            cols = jQuery(this).children("td");
            cols.eq(ix).clone().insertAfter(cols.eq(ix)).html("").attr("class","new");
        });
        $newColumn.add("new");
        $newColumn.setColumn({"new" : {}});
        $caption = $newColumn.addClass("new").find("td.caption");
        $caption.html("&nbsp;");
        Adhoc.Checklist.columnDialog.trigger = $caption.get(0);
        _.delay(function() { $caption.click(); });
    };

    Adhoc.Checklist.getColumnIndex = function($columnHeader, $checklist) {
        $columnHeader.addClass("moving");
        var count = 0;
        var ix = -1;
        $checklist.find("tr.headings th").each(function() {
            if ($(this).hasClass("moving")) {
                ix = count;
            }
            count++;
        });
        $columnHeader.removeClass("moving");
        return ix;
    };

    var moveCellsRight = function($rows, ix, selector) {
        var cols;
        $rows.each(function() {
            cols = jQuery(this).children(selector);
            cols.eq(ix).detach().insertAfter(cols.eq(ix + 1));
        });
    };

    Adhoc.Checklist.removeColumn = function($columnHeader) {
        var $checklist = $columnHeader.parents("table.adhocchecklist");
        if ($checklist.find("tr.headings th").length == 1) {
            // todo: message saying there has to be at least one column
            return;
        }
        var ix = Adhoc.Checklist.getColumnIndex($columnHeader, $checklist);
        $checklist.find("tr.headings th.heading").eq(ix).remove();
        $checklist.find("tbody.rows tr").each(function() {
            $(this).children("td").eq(ix).remove();
        });
    };


    Adhoc.Checklist.moveCellsToFirstColumn = function($rows, ix, selector) {
        var cols;
        $rows.each(function() {
            cols = jQuery(this).children(selector);
            cols.eq(ix).detach().insertBefore(cols.eq(0));
        });
    };

    Adhoc.Checklist.refresh = function() {
        Adhoc.Checklist.update();
        var $checklistRows = $("tbody.rows");
        $checklistRows.empty();
        $.ajax({
            type: "POST",
            cache: false,
            data: Adhoc.Checklist.toJson(),
            contentType: "application/json",
            url: CB.contextPath + "/rest/adhoclists/latest/lists/rows" +
                    "?spaceKey=" + CB.getParam('spaceKey') +
                    "&start=" + 0 +
                    "&count=" + 5 +
                    "&labels=" + Adhoc.filter.labelsList()
                    ,
            success: function (data, textStatus, jqXHR) {
                $checklistRows.append(data);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Adhoc.common.errorHandler($(".checklistwrapper"),jqXHR, textStatus,errorThrown);
            }
        });

    };

    var generateColumnDialog = function (InlineDialog) {
        var $contents = InlineDialog.getContainer();
        var $trigger = $(InlineDialog.trigger);
        Adhoc.addSmallSpinner($contents);
        var $heading = $trigger.parents("th.heading");
        var column = $trigger.getColumnInfo();
        if ($heading.hasClass("new")) {
            $.ajax({
                type: "GET",
                cache: false,
                contentType: "text/plain; charset=utf-8",
                url: CB.contextPath + "/rest/adhoclists/latest/lists/form/new",
                success: function (formHtml) {
                    $contents.html(formHtml);
                    $contents.find("form.aui.checklist").addClass("new").data("column",column);
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Adhoc.common.errorHandler($(".checklistwrapper"),jqXHR, textStatus,errorThrown);
                }
            });
        } else {
            $.ajax({
                type: "POST",
                cache: false,
                contentType: "application/json",
                url: CB.contextPath + "/rest/adhoclists/latest/lists/form?type=" + column.type + "&spaceKey=" + Adhoc.Checklist.spaceKey,
                data: column.toJson(),
                success: function (formHtml) {
                    $contents.html(formHtml);
                    $contents.find("form.aui.checklist").data("column",column);
                    $(".accept",$contents).toggleButton($("input.required",$contents));
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Adhoc.common.errorHandler($(".checklistwrapper"),jqXHR, textStatus,errorThrown);
                }
            });
        }
    };

    Adhoc.Checklist.removeNewColumn = function(InlineDialog) {
        var $form = InlineDialog.$el.find("form.checklist");
        var $heading = $form.getColumnInfo().$heading;
        if ($form.hasClass("new") || $heading.hasClass("empty")) {
            Adhoc.Checklist.removeColumn($heading);
        }
    };

    Adhoc.Checklist.checklistDesigner = function () {
        CB.log("init checklist designer");
        if (Adhoc.Checklist.columnDialog) {
            Adhoc.Checklist.columnDialog.remove();
        }
        Adhoc.Checklist.columnDialog = new CB.InlineDialog({
            id: 'columnDialog',
            width: 320,
            trigger: '.adhocchecklist.edit .headings .heading .caption',
            content: generateColumnDialog,
            alignment: 'bottom left',
            onHide: Adhoc.Checklist.removeNewColumn,
            className: 'cc-inline-dialog-columnPopup'
        });
        $(document.body).append(Adhoc.Checklist.columnDialog.render());
    };

    CB.toInit(function() {
        $(document).on('click', ".cnv-list-movecolumn", function(event) {
            event.preventDefault();
            Adhoc.Checklist.moveColumn($(this).parents("th.heading"));
        });
        $(document).on('click', ".cnv-list-addcolumn", function(event){
            event.preventDefault();
            var $heading = $(this).parents("th.heading");
            Adhoc.Checklist.addColumn($heading);
        });
        $(document).on('click', "form.aui.checklist.column .delete",function(event) {
            event.preventDefault();
            var $heading = $(this).getColumnInfo().$heading;
            Adhoc.doIfconfirm($heading.find("td.caption").text(),
                    CB.I18n.getText("adhoclists.checklists.designer.column.delete"),function() {
                        event.preventDefault();
                        Adhoc.Checklist.columnDialog.hide();
                        Adhoc.Checklist.removeColumn($heading);
                    });
            });
        $(document).on('click', "form.aui.checklist.column .cancel", function(event) {
            event.preventDefault();
            Adhoc.Checklist.columnDialog.hide();
        });

        $(document).on('click', "form.aui.checklist.column .moredetails a", function(event) {
            event.preventDefault();
            $(this).parents(".moredetails").addClass("hidden");
            $(".columndetails",$(this).parents("form")).removeClass("hidden");
        });
        $(document).on('change', "#column-type", function(event) {
            event.preventDefault();
            var type = $(this).find("option:selected").val();
            var columnInfo = $(this).getColumnInfo();
            var str = "({\"" + type + "\":{}})";
            var newColumn = eval(str);
            columnInfo.$heading.setColumn(newColumn);
            columnInfo.$heading.removeClass("new").addClass("empty");
            generateColumnDialog(Adhoc.Checklist.columnDialog);
        });

        $(document).on('change', "#checklistname", function() {
            $(".savechecklist").toggleButton($(this));
            $(".continuechecklist").toggleButton($(this));
        }).change();
        $(document).on('keyup', "#checklistname", function() {
            $(".savechecklist").toggleButton($(this));
            $(".continuechecklist").toggleButton($(this));
        }).change();
        $(document).on('change keyup', "input.required", function() {
            var $form = $(this).parents("form.aui");
            var $required = $("input.required",$form);
            $(".accept",$form).toggleButton($required);
        });
        $(document).on('click', ".savechecklist", function() {
            saveChecklist();
        });
        $(document).on('click', ".continuechecklist", function(event) {
            event.preventDefault();
            $(".spacechecklistdesigner").removeClass("NEW");
            CB.changeTab($("a[href=#checklist-editor-tab]"))
        });
        $(document).on('submit', ".checklistproperties", function(event){
            event.preventDefault();
            $(".spacechecklistdesigner").removeClass("NEW");
            CB.changeTab($("a[href=#checklist-editor-tab]"));
        });
    });
});
