/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage.serializer;

import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.storage.serializer.Serializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class TableJasonSerializer<T extends Table>
implements Serializer<T>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TableJasonSerializer.class);
    protected ObjectMapper mapper;

    @Override
    public String serialize(T table) {
        StringWriter writer = new StringWriter();
        try {
            this.mapper.writeValue((Writer)writer, table);
            return writer.toString();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    protected abstract Class getTableClass();

    @Override
    public T deserialize(String table) {
        try {
            return (T)((Table)this.mapper.readValue(table, this.getTableClass()));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Error deserializing " + table, (Throwable)e);
            } else {
                log.error("Error deserializing " + table);
            }
            return null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.mapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this.mapper.setDeserializationConfig(this.mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspector));
        this.mapper.setSerializationConfig(this.mapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspector));
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

