/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.condition;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.adhoclists.condition.AllowedInSpaceCondition;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;

public class RestConditionImpl
implements RestCondition {
    private SpaceManager spaceManager;
    private AllowedInSpaceCondition boardsCondition;
    private AllowedInSpaceCondition listsCondition;

    public RestConditionImpl(GlobalConfigManager globalConfigManager, SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
        this.boardsCondition = new AllowedInSpaceCondition(globalConfigManager).setItem("board");
        this.listsCondition = new AllowedInSpaceCondition(globalConfigManager).setItem("list");
    }

    @Override
    public boolean isBoardsVisible(ConfluenceEntityObject ceo) {
        DefaultWebInterfaceContext context = this.getContext(ceo);
        return this.boardsCondition.shouldDisplay((WebInterfaceContext)context);
    }

    @Override
    public boolean isListsVisible(ConfluenceEntityObject ceo) {
        DefaultWebInterfaceContext context = this.getContext(ceo);
        return this.listsCondition.shouldDisplay((WebInterfaceContext)context);
    }

    private DefaultWebInterfaceContext getContext(ConfluenceEntityObject ceo) {
        DefaultWebInterfaceContext context = new DefaultWebInterfaceContext();
        if (ceo instanceof Space) {
            context.setSpace((Space)ceo);
        } else if (ceo instanceof AbstractPage) {
            context.setSpace(((AbstractPage)ceo).getSpace());
        } else if (ceo instanceof Draft) {
            String spaceKey = ((Draft)ceo).getDraftSpaceKey();
            context.setSpace(this.spaceManager.getSpace(spaceKey));
        } else if (ceo instanceof PageTemplate) {
            context.setSpace(((PageTemplate)ceo).getSpace());
        }
        return context;
    }
}

