/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.AbstractTableCreator;
import com.comalatech.confluence.adhoclists.boards.BoardCreator;
import com.comalatech.confluence.adhoclists.model.Styles;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.Container;
import com.comalatech.confluence.boards.rest.model.UserInfo;
import com.comalatech.confluence.boards.util.BoardUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultBoardCreator
extends AbstractTableCreator
implements BoardCreator {
    private static final int MAX_BOARD_COLUMNS = 5;
    public static final int MAX_POPULAR_LABELS = 20;
    private final PageManager pageManager;
    private final LabelManager labelManager;
    private final UserAccessor userAccessor;

    public DefaultBoardCreator(LabelManager labelManager, PageManager pageManager, PermissionManager permissionManager, UserAccessor userAccessor) {
        super(permissionManager);
        this.labelManager = labelManager;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
    }

    @Override
    public Board createPopularLabelsBoard(String spaceKey) {
        List popularLabels = this.labelManager.getMostPopularLabelsInSpace(spaceKey, 20);
        Board board = new Board(ConfluenceActionSupport.getTextStatic((String)"title.labels.popular"), Board.Type.LABEL);
        Board.Row row = null;
        int count = 0;
        int totalPages = 0;
        for (LabelSearchResult popularLabel : popularLabels) {
            totalPages += popularLabel.getCount();
            if (count % 5 == 0) {
                row = board.addRow();
            }
            Container container = new Container(popularLabel.getLabel().getName(), popularLabel.getLabel().getName());
            container.setStyle(Styles.getStyle(count));
            row.addColumn().add(container);
            ++count;
        }
        board.setMatchRowHeight(true);
        return board;
    }

    @Override
    public Board resolveUserOnContainerCaption(Board board) {
        board.getRows().stream().forEach(row -> row.getColumns().stream().forEach(column -> column.getContainers().stream().forEach(container -> {
            String username;
            ConfluenceUser user;
            String containerCaption = container.getCaption();
            if (StringUtils.isNotEmpty((CharSequence)containerCaption) && containerCaption.contains("@") && (user = this.userAccessor.getUserByName(username = BoardUtils.extractUsernameFromString(containerCaption))) != null) {
                ProfilePictureInfo profilePictureInfo = this.userAccessor.getUserProfilePicture((User)user);
                UserInfo userInfo = new UserInfo(user.getFullName(), user.getEmail());
                if (profilePictureInfo != null) {
                    userInfo.profilePictureUrl = profilePictureInfo.getUriReference();
                }
                board.getUserInfoList().put(username, userInfo);
            }
        })));
        return board;
    }
}

