AJS.toInit(function($) {
	AJS.Confluence.PropertyPanel.Image.pluginButtons.push(
			null,
			{
				create: function(img) {
					return {
						className: 'image-rotate-auto',
						text: null,
						tooltip: AJS.I18n.getText('com.celestecs.confluence.image-lossless-rotator.button.tooltip.auto'),
						disabled: false,
						selected: false,
						click: function(a, img) {
							rotate(AJS.$(img), 0);
						},
					}
				}
			},
			{
				create: function(img) {
					return {
						className: 'image-rotate-counter-clockwise',
						text: null,
						tooltip: AJS.I18n.getText('com.celestecs.confluence.image-lossless-rotator.button.tooltip.counter-clockwise'),
						disabled: false,
						selected: false,
						click: function(a, img) {
							rotate(AJS.$(img), -1);
						},
					}
				}
			},
			{
				create: function(img) {
					return {
						className: 'image-rotate-clockwise',
						text: null,
						tooltip: AJS.I18n.getText('com.celestecs.confluence.image-lossless-rotator.button.tooltip.clockwise'),
						disabled: false,
						selected: false,
						click: function(a, img) {
							rotate(AJS.$(img), 1);
						},
					}
				}
			}
	);

	rotate = function($img, rotationType) {
//		var bSuccess = false;
//		var strClass = $img.attr('class');
//		var strSrcUrl = $img.attr('data-image-src');
//		var attachmentId = 0;
//		if (strClass != 'Undefined' && strClass.indexOf("confluence-external-resource") > -1)
//		{
//			var url = AJS.params.contextPath + '/rest/image-lossless-rotator/1.0/download';
//			AJS.safe.get(url, { url: strSrcUrl})
//			.done(function(response, status, header) {
//				if (header.getResponseHeader('Licensing') == "NotOK")	//	It's just a check to show alert. Plugin won't work without a license anyways. 
//				{
//					alert (response);
//				}
//				else
//				{
//					//	work with response
//					attachmentId = response;
//					bSuccess = true;
//				}
//			})
//			.fail(function(header, status, error) {}
//			);
//			if (bSuccess)
//			{
//				rotateAttachment($img, rotationType);
//			}						
//		}
//		else
//		{			
			var attachmentId = $img.attr('data-linked-resource-id');
			rotateAttachment($img, rotationType, attachmentId);
//		}
		
		function rotateAttachment($img, rotationType, atachmentId)
		{
			var url = AJS.params.contextPath + '/rest/image-lossless-rotator/1.0/rotate';
			AJS.safe.get(url, { attachmentId: attachmentId, rotationType: rotationType})
			.done(function(response, status, header) {
				if (header.getResponseHeader('Licensing') == "NotOK")	//	It's just a check to show alert. Plugin won't work without a license anyways. 
				{
					alert (response);
				}
				else
				{
					var imageProps = AJS.Confluence.PropertyPanel.current.imageProps;
					updateImageProps(response, imageProps);
					updateImageElement($img, imageProps);
				}
			})
			.fail(function(header, status, error) {}
			);
		}

		function updateImageProps(newImageUrl, imageProps) {
			imageProps.destination = newImageUrl;
			delete imageProps['height'];
			imageProps.thumbnail = !tinymce.confluence.ImageUtils.isRemoteImg(newImageUrl)
			&& (imageProps.width <= AJS.Meta.get('max-thumb-width'));
		}

		function updateImageElement($img, imageProps) {
			var ppanel = AJS.Confluence.PropertyPanel.current,
			oldSrc = $img.attr('src'),
			oldHeight = $img.height();
			ppanel.updating = true;
			var rebindAndSnap = function () {
				ppanel.updating = false;
				ppanel.snapToElement({
					animate: true,
					animateDuration: 100,
				});
			};

			tinymce.confluence.ImageUtils.updateImageElement($img, imageProps);
			if (tinymce.isGecko) {
				AJS.Rte.getEditor().execCommand('mceRepaint', false);
			}

			if (imageProps.src != oldSrc) {
				var snapInterval = setInterval(function() {
					var newHeight = $img.height();
					if (newHeight != oldHeight) {
						clearTimeout(snapInterval);
						snapInterval = null;
						rebindAndSnap();
					}
				}, 10);
				setTimeout(function() {
					if (snapInterval) {
						clearTimeout(snapInterval);
						snapInterval = null;
						rebindAndSnap();
					}
				}, 1000);
			} else {
				rebindAndSnap();
			}
		}
	}
});
