/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.Naming;

public class Record
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer type;
    private float mainfloatvalue;
    private float floatvalue1;
    private float floatvalue2;
    private int mainvalue;
    private int reserved1;
    private int reserved2;
    private int reserved3;
    private int imagewidth;
    private int imageheight;
    private int rotationangle;
    private int componentbitdepth;
    private int colorbitdepth;
    private int colorbw;
    private String stringvalue;

    public Record(int type) {
        this.type = new Integer(type);
    }

    public Record(int type, String value) {
        this(type);
        this.stringvalue = value;
    }

    public Record(int type, int value) {
        this(type);
        this.mainvalue = value;
    }

    public Record(int type, int value, float value2) {
        this(type, value);
        this.mainfloatvalue = value2;
    }

    public Record(int type, int value, int value1, int value2) {
        this(type, value);
        this.reserved1 = value1;
        this.reserved2 = value2;
    }

    public Record(int type, float value) {
        this(type);
        this.mainfloatvalue = value;
    }

    public Record(int type, float value, float value1) {
        this(type, value);
        this.floatvalue1 = value1;
    }

    public Record(int type, float value, float value1, float value2) {
        this(type, value, value1);
        this.floatvalue2 = value2;
    }

    public Record(int type, int w, int h, float par, int ra, int compbits, int colorbits, int colorbw) {
        this(type);
        this.imagewidth = w;
        this.imageheight = h;
        this.rotationangle = ra;
        this.mainfloatvalue = par;
        this.componentbitdepth = compbits;
        this.colorbitdepth = colorbits;
        this.colorbw = colorbw;
    }

    public int getWidth() {
        return this.imagewidth;
    }

    public int getHeight() {
        return this.imageheight;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTypeName() {
        return Naming.getPropName(this.type);
    }

    public float getFloatValue() {
        return this.mainfloatvalue;
    }

    public float getFloatValue(int i) {
        if (i > 1) {
            return this.floatvalue2;
        }
        return this.floatvalue1;
    }

    public int getIntValue() {
        return this.mainvalue;
    }

    public String toString() {
        if (this.stringvalue != null) {
            return this.stringvalue;
        }
        StringBuffer result = new StringBuffer();
        switch (this.type) {
            case 6160: {
                result.append(this.imagewidth);
                result.append("x");
                result.append(this.imageheight);
                result.append(" Ratio: ");
                result.append(this.mainfloatvalue);
                result.append(" Rotation: ");
                result.append(this.rotationangle);
                result.append(" Bit depth: ");
                result.append(this.componentbitdepth);
                return result.toString();
            }
            case 6168: {
                result.append("Compensation: ");
                result.append(this.mainfloatvalue);
                result.append(" TV: ");
                result.append(this.floatvalue1);
                result.append(" AV: ");
                result.append(this.floatvalue2);
                return result.toString();
            }
            case 6151: {
                result.append(this.mainfloatvalue);
                return result.toString();
            }
            case 6148: {
                result.append(this.mainvalue);
                return result.toString();
            }
            case 6147: {
                result.append("JPEG:");
                switch (this.mainvalue & 0xFFFF) {
                    case 0: {
                        result.append("lossy");
                        break;
                    }
                    case 1: {
                        result.append("none");
                        break;
                    }
                    case 2: {
                        result.append("DCT");
                        break;
                    }
                    case 3: {
                        result.append("PS600");
                    }
                }
                return result.toString();
            }
            case 4113: {
                result.append(this.mainvalue == 0 ? "Shutter" : "Focus");
                return result.toString();
            }
            case 4112: {
                result.append(this.mainvalue == 0 ? "Single" : "Continuous");
                return result.toString();
            }
            case 4106: {
                result.append(this.mainvalue == 0 ? "Real-world" : "Written");
                return result.toString();
            }
            case 6167: {
                result.append(this.mainvalue);
                return result.toString();
            }
            case 6163: {
                result.append(this.mainfloatvalue);
                return result.toString();
            }
            case 6164: {
                result.append(this.mainfloatvalue);
                return result.toString();
            }
            case 6155: {
                result.append(this.mainvalue);
                return result.toString();
            }
            case 4124: {
                result.append(this.mainvalue);
                return result.toString();
            }
            case 6158: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date((long)this.mainvalue * 1000L));
                result.append(AbstractImageInfo.dateformat.format(new Date((long)this.mainvalue * 1000L + (long)(-(cal.get(15) + cal.get(16))))));
                return result.toString();
            }
        }
        return Naming.getPropName(this.type);
    }
}

