/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.util.HashMap;
import java.util.Map;
import mediautil.image.jpeg.Entry;

public class IFD
extends Entry {
    private static final long serialVersionUID = 1L;
    protected Map entries;
    protected IFD[] ifds;
    protected int tag;

    public IFD(int tag) {
        this(tag, 7);
    }

    public IFD(int tag, int type) {
        super(type);
        this.tag = tag;
        this.entries = new HashMap();
    }

    public void addEntry(int tag, Entry entry) {
        this.entries.put(new Integer(tag), entry);
    }

    public void removeEntry(int tag) {
        this.entries.remove(new Integer(tag));
    }

    public void addIFD(IFD ifd) {
        IFD[] temp = this.ifds == null ? new IFD[1] : new IFD[this.ifds.length + 1];
        temp[this.ifds == null ? 0 : this.ifds.length] = ifd;
        if (this.ifds != null) {
            System.arraycopy(this.ifds, 0, temp, 0, this.ifds.length);
        }
        this.ifds = temp;
    }

    public Entry getEntry(Integer tag, int subTag) {
        Entry result = (Entry)this.entries.get(tag);
        if (result != null) {
            return result;
        }
        if (subTag > 0) {
            for (int i = 0; i < this.ifds.length; ++i) {
                if (this.ifds[i].getTag() != subTag) continue;
                return this.ifds[i].getEntry(tag, -1);
            }
        } else {
            for (int i = 0; this.ifds != null && i < this.ifds.length && (result = this.ifds[i].getEntry(tag, -1)) == null; ++i) {
            }
        }
        return result;
    }

    public IFD getIFD(int tag) {
        for (int i = 0; i < this.ifds.length; ++i) {
            if (this.ifds[i].getTag() != tag) continue;
            return this.ifds[i];
        }
        return null;
    }

    public int getTag() {
        return this.tag;
    }

    public Entry setEntry(Integer tag, int subTag, Entry value) {
        Entry result = null;
        if (subTag > 0) {
            for (int i = 0; i < this.ifds.length; ++i) {
                if (this.ifds[i].getTag() != subTag) continue;
                return this.ifds[i].setEntry(tag, -1, value);
            }
        } else if (subTag == 0) {
            result = this.entries.put(tag, value);
        } else {
            for (int i = 0; i < this.ifds.length; ++i) {
                result = this.ifds[i].getEntry(tag, -1);
                if (result == null) continue;
                this.ifds[i].setEntry(tag, 0, value);
                break;
            }
        }
        return result;
    }

    public Map getEntries() {
        return this.entries;
    }

    public IFD[] getIFDs() {
        return this.ifds;
    }
}

