/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.statistical;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.operators.CalculatorEqual;
import com.celestecs.expression.calculators.operators.CalculatorGreater;
import com.celestecs.expression.calculators.operators.CalculatorGreaterOrEqual;
import com.celestecs.expression.calculators.operators.CalculatorLess;
import com.celestecs.expression.calculators.operators.CalculatorLessOrEqual;
import com.celestecs.expression.calculators.operators.CalculatorNotEqual;

public final class CalculatorCountIf
extends CalculatorBase {
    public static final int NONE = 0;
    public static final int EQ = 1;
    public static final int NE = 2;
    public static final int LE = 3;
    public static final int LT = 4;
    public static final int GT = 5;
    public static final int GE = 6;

    public CalculatorCountIf(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        if (null == (objParams = Conversion.objectArrayWithRangesToFlatObjectArray(objParams)) || objParams.length < 2) {
            return 0;
        }
        Object objValue = objParams[objParams.length - 1];
        String strValue = null == objValue ? "" : CalculatorCountIf.getValue(objValue.toString());
        CalculatorBase calc = null;
        if (null == objValue || strValue.length() == objValue.toString().length()) {
            calc = this.getCalculator(1);
        } else {
            int operation = CalculatorCountIf.getOperation(objValue.toString());
            calc = this.getCalculator(operation);
            objValue = strValue;
        }
        Object[] calcParams = new Object[2];
        calcParams[1] = objValue;
        long count = 0L;
        for (int i = 0; i < objParams.length - 1; ++i) {
            Object objParam;
            calcParams[0] = objParam = objParams[i];
            Object objResult = calc.Calculate(calcParams);
            if (null == objResult || !(objResult instanceof Boolean) || !((Boolean)objResult).booleanValue()) continue;
            ++count;
        }
        return new Long(count);
    }

    public CalculatorBase getCalculator(int operation) {
        CalculatorBase calc = null;
        switch (operation) {
            case 0: 
            case 1: {
                calc = new CalculatorEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 2: {
                calc = new CalculatorNotEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 3: {
                calc = new CalculatorLessOrEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 4: {
                calc = new CalculatorLess(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 5: {
                calc = new CalculatorGreater(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 6: {
                calc = new CalculatorGreaterOrEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            default: {
                calc = new CalculatorEqual(this.decimalSymbol, this.digitGroupingSymbol);
            }
        }
        return calc;
    }

    public static int getOperation(String param) {
        int len = param.length();
        if (len < 1) {
            return 0;
        }
        char firstChar = param.charAt(0);
        switch (firstChar) {
            case '=': {
                return 1;
            }
            case '>': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return 6;
                        }
                    }
                }
                return 5;
            }
            case '<': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return 3;
                        }
                        case '>': {
                            return 2;
                        }
                    }
                }
                return 4;
            }
        }
        return 1;
    }

    public static String getValue(String param) {
        if (null == param) {
            return "";
        }
        int len = param.length();
        if (len < 1) {
            return "";
        }
        char firstChar = param.charAt(0);
        switch (firstChar) {
            case '=': {
                return param.substring(1);
            }
            case '>': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return param.substring(2);
                        }
                    }
                }
                return param.substring(1);
            }
            case '<': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return param.substring(2);
                        }
                        case '>': {
                            return param.substring(2);
                        }
                    }
                }
                return param.substring(1);
            }
        }
        return param;
    }
}

