/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.json;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

public final class CalculatorJsonArrayGetLast
extends CalculatorBase {
    public CalculatorJsonArrayGetLast(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 1 || objParams.length > 2) {
            throw new IllegalArgumentException("Wrong parameter count, which should be 1 or 2.");
        }
        if (null == objParams[0] || objParams[0].toString().isEmpty()) {
            return null;
        }
        String resultIfNan = "NaN";
        if (objParams.length >= 2 && null != objParams[1]) {
            resultIfNan = objParams[1].toString();
        }
        Object objJson = null;
        if (null != objParams[0]) {
            objJson = objParams[0];
        }
        if (null == objJson) {
            return resultIfNan;
        }
        try {
            JsonArray jsonArray = null;
            if (!(objJson instanceof JsonArray)) {
                JsonParser jsonParser = new JsonParser();
                JsonElement jsonParsed = jsonParser.parse(objJson.toString());
                if (null != jsonParsed && jsonParsed instanceof JsonArray) {
                    jsonArray = (JsonArray)jsonParsed;
                }
            } else {
                jsonArray = (JsonArray)objJson;
            }
            if (null == jsonArray) {
                return resultIfNan;
            }
            if (jsonArray.size() < 1) {
                return resultIfNan;
            }
            JsonElement jsonElement = jsonArray.get(jsonArray.size() - 1);
            if (null == jsonElement) {
                return resultIfNan;
            }
            String strResult = jsonElement.getAsString();
            return strResult;
        }
        catch (Exception e) {
            throw new CalculatorException(e.getMessage(), this, objParams);
        }
    }
}

