/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.financial;

public final class FinanceFunctions {
    private FinanceFunctions() {
    }

    public static double fv(double r, double n, double y, double p, int t) {
        double retval = 0.0;
        if (r == 0.0) {
            retval = -1.0 * (p + n * y);
        } else {
            double r1 = r + 1.0;
            retval = (1.0 - Math.pow(r1, n)) * (t != 0 ? r1 : 1.0) * y / r - p * Math.pow(r1, n);
        }
        return retval;
    }

    public static double pv(double r, double n, double y, double f, int t) {
        double retval = 0.0;
        if (r == 0.0) {
            retval = -1.0 * (n * y + f);
        } else {
            double r1 = r + 1.0;
            retval = ((1.0 - Math.pow(r1, n)) / r * (t != 0 ? r1 : 1.0) * y - f) / Math.pow(r1, n);
        }
        return retval;
    }

    public static double npv(double r, double[] cfs) {
        double r1;
        double npv = 0.0;
        double trate = r1 = r + 1.0;
        int iSize = cfs.length;
        for (int i = 0; i < iSize; ++i) {
            npv += cfs[i] / trate;
            trate *= r1;
        }
        return npv;
    }

    public static double pmt(double r, double n, double p, double f, int t) {
        double retval = 0.0;
        if (r == 0.0) {
            retval = -1.0 * (f + p) / n;
        } else {
            double r1 = r + 1.0;
            retval = (f + p * Math.pow(r1, n)) * r / ((t != 0 ? r1 : 1.0) * (1.0 - Math.pow(r1, n)));
        }
        return retval;
    }

    public static double nper(double r, double y, double p, double f, int t) {
        double retval = 0.0;
        if (r == 0.0) {
            retval = -1.0 * (f + p) / y;
        } else {
            double r1 = r + 1.0;
            double ryr = (t != 0 ? r1 : 1.0) * y / r;
            double a1 = ryr - f < 0.0 ? Math.log(f - ryr) : Math.log(ryr - f);
            double a2 = ryr - f < 0.0 ? Math.log(-p - ryr) : Math.log(p + ryr);
            double a3 = Math.log(r1);
            retval = (a1 - a2) / a3;
        }
        return retval;
    }

    public static double ipmt(double r, int per, int nper, double pv, double fv, int type) {
        double ipmt = FinanceFunctions.fv(r, per - 1, FinanceFunctions.pmt(r, nper, pv, fv, type), pv, type) * r;
        if (type == 1) {
            ipmt /= 1.0 + r;
        }
        return ipmt;
    }

    public static double ppmt(double r, int per, int nper, double pv, double fv, int type) {
        return FinanceFunctions.pmt(r, nper, pv, fv, type) - FinanceFunctions.ipmt(r, per, nper, pv, fv, type);
    }

    public static double fv1(double r, int nper, double pmt, double pv, int type) {
        double fv = -(pv * Math.pow(1.0 + r, nper) + pmt * (1.0 + r * (double)type) * (Math.pow(1.0 + r, nper) - 1.0) / r);
        return fv;
    }
}

