/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.financial;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorMirr
extends CalculatorBase {
    public CalculatorMirr(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        double[] parameters = Conversion.objectArrayToDoubleArray(objParams = Conversion.objectArrayWithRangesToFlatObjectArray(objParams), this.decimalSymbol, this.digitGroupingSymbol);
        if (parameters.length < 3) {
            throw new IllegalArgumentException("Wrong parameter count, which should be not less than 3.");
        }
        double[] Values = new double[parameters.length - 2];
        for (int i = 0; i < parameters.length - 2; ++i) {
            Values[i] = parameters[i];
        }
        double Finance_rate = parameters[parameters.length - 2];
        double Reinvest_rate = parameters[parameters.length - 1];
        return new Double(CalculatorMirr.mirr(Values, Finance_rate, Reinvest_rate));
    }

    private static double mirr(double[] in, double financeRate, double reinvestRate) {
        double value = 0.0;
        int numOfYears = in.length - 1;
        double pv = 0.0;
        double fv = 0.0;
        int indexN = 0;
        for (double anIn : in) {
            if (!(anIn < 0.0)) continue;
            pv += anIn / Math.pow(1.0 + financeRate + reinvestRate, indexN++);
        }
        for (double anIn : in) {
            if (!(anIn > 0.0)) continue;
            fv += anIn * Math.pow(1.0 + financeRate, numOfYears - indexN++);
        }
        if (fv != 0.0 && pv != 0.0) {
            value = Math.pow(-fv / pv, 1.0 / (double)numOfYears) - 1.0;
        }
        return value;
    }
}

