/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.engineering;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.ErrorEval;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CalculatorImaginary
extends CalculatorBase {
    public static final String GROUP1_REAL_SIGN_REGEX = "([+-]?)";
    public static final String GROUP2_REAL_INTEGER_OR_DOUBLE_REGEX = "([0-9]+\\.[0-9]+|[0-9]*)";
    public static final String GROUP3_IMAGINARY_SIGN_REGEX = "([+-]?)";
    public static final String GROUP4_IMAGINARY_INTEGER_OR_DOUBLE_REGEX = "([0-9]+\\.[0-9]+|[0-9]*)";
    public static final String GROUP5_IMAGINARY_GROUP_REGEX = "([ij]?)";
    public static final Pattern COMPLEX_NUMBER_PATTERN = Pattern.compile("([+-]?)([0-9]+\\.[0-9]+|[0-9]*)([+-]?)([0-9]+\\.[0-9]+|[0-9]*)([ij]?)");
    public static final int GROUP1_REAL_SIGN = 1;
    public static final int GROUP2_IMAGINARY_INTEGER_OR_DOUBLE = 2;
    public static final int GROUP3_IMAGINARY_SIGN = 3;
    public static final int GROUP4_IMAGINARY_INTEGER_OR_DOUBLE = 4;

    public CalculatorImaginary(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckParams(objParams, 1);
        super.CheckForNotHavingRanges(objParams);
        if (null == objParams[0] || null == objParams[0].toString()) {
            return 0;
        }
        String iNumber = objParams[0].toString();
        if (Conversion.isDoubleOrLong(iNumber, this.decimalSymbol, this.digitGroupingSymbol)) {
            return new Double(0.0);
        }
        Matcher m = COMPLEX_NUMBER_PATTERN.matcher(iNumber);
        boolean result = m.matches();
        String imaginary = "";
        if (result) {
            boolean hasImaginaryPart;
            String imaginaryGroup = m.group(5);
            boolean bl = hasImaginaryPart = imaginaryGroup.equals("i") || imaginaryGroup.equals("j");
            if (imaginaryGroup.length() == 0) {
                return new String("");
            }
            if (hasImaginaryPart) {
                String groupImaginaryNumber;
                String sign = "";
                String imaginarySign = m.group(3);
                if (imaginarySign.length() != 0 && !imaginarySign.equals("+")) {
                    sign = imaginarySign;
                }
                imaginary = (groupImaginaryNumber = m.group(4)).length() != 0 ? sign + groupImaginaryNumber : sign + "1";
            }
        } else {
            return ErrorEval.NUM_ERROR;
        }
        return new Double(Conversion.objectToDouble(imaginary, this.decimalSymbol, this.digitGroupingSymbol));
    }
}

