/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dateandtime;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.LocaleUtil;

public final class CalculatorNetWorkdays
extends CalculatorBase {
    public CalculatorNetWorkdays(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        if (null == (objParams = Conversion.objectArrayWithRangesToFlatObjectArray(objParams)) || objParams.length < 2) {
            throw new IllegalArgumentException("Wrong parameter count, which should be be greater or equal to 2.");
        }
        for (Object d : objParams) {
            if (null != d && Conversion.isDateTime(d)) continue;
            throw new IllegalArgumentException("The NETWORKDAYS function parameter with the value '" + d + "' does not look to be a valid date.");
        }
        try {
            DateTime d0 = Conversion.objectToDateTime(objParams[0]);
            Date jd0 = DateTime.getClearDate(DateUtil.getJavaDate(d0.getValue()));
            double dd0 = DateUtil.getExcelDate(jd0);
            DateTime d1 = Conversion.objectToDateTime(objParams[1]);
            Date jd1 = DateTime.getClearDate(DateUtil.getJavaDate(d1.getValue()));
            double dd1 = DateUtil.getExcelDate(jd1);
            ArrayList<Double> arrHolidays = new ArrayList<Double>();
            for (int i = 2; i < objParams.length; ++i) {
                DateTime dzz = Conversion.objectToDateTime(objParams[i]);
                Date jdzz = DateTime.getClearDate(DateUtil.getJavaDate(dzz.getValue()));
                double ddzz = DateUtil.getExcelDate(jdzz);
                arrHolidays.add(ddzz);
            }
            Double[] holidays = arrHolidays.size() < 1 ? null : arrHolidays.toArray(new Double[1]);
            int res = this.calculateWorkdays(dd0, dd1, holidays);
            return new Long(res);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public int calculateWorkdays(Double start, Double end, Double[] holidays) {
        int saturdaysPast = CalculatorNetWorkdays.pastDaysOfWeek(start, end, 7);
        int sundaysPast = CalculatorNetWorkdays.pastDaysOfWeek(start, end, 1);
        int nonWeekendHolidays = null == holidays || holidays.length < 1 ? 0 : CalculatorNetWorkdays.calculateNonWeekendHolidays(start, end, holidays);
        return (int)(end - start + 1.0) - saturdaysPast - sundaysPast - nonWeekendHolidays;
    }

    public static Date calculateWorkdays(Double start, int workdays, Double[] holidays) {
        Date startDate = DateUtil.getJavaDate(start);
        int direction = workdays < 0 ? -1 : 1;
        Calendar endDate = LocaleUtil.getLocaleCalendar();
        endDate.setTime(startDate);
        double excelEndDate = DateUtil.getExcelDate(endDate.getTime());
        while (workdays != 0) {
            endDate.add(6, direction);
            if (endDate.get(7) == 7 || endDate.get(7) == 1 || CalculatorNetWorkdays.isHoliday(excelEndDate += (double)direction, holidays)) continue;
            workdays -= direction;
        }
        return endDate.getTime();
    }

    protected static int pastDaysOfWeek(double start, double end, int dayOfWeek) {
        int pastDaysOfWeek = 0;
        int endDay = (int)Math.floor(end > start ? end : start);
        for (int startDay = (int)Math.floor(start < end ? start : end); startDay <= endDay; ++startDay) {
            Calendar today = LocaleUtil.getLocaleCalendar();
            today.setTime(DateUtil.getJavaDate(startDay));
            if (today.get(7) != dayOfWeek) continue;
            ++pastDaysOfWeek;
        }
        return start <= end ? pastDaysOfWeek : -pastDaysOfWeek;
    }

    protected static int calculateNonWeekendHolidays(Double start, Double end, Double[] holidays) {
        int nonWeekendHolidays = 0;
        double startDay = start < end ? start : end;
        double endDay = end > start ? end : start;
        Double[] doubleArray = holidays;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double holiday = doubleArray[i];
            if (!CalculatorNetWorkdays.isInARange(startDay, endDay, holiday) || CalculatorNetWorkdays.isWeekend(holiday)) continue;
            ++nonWeekendHolidays;
        }
        return start <= end ? nonWeekendHolidays : -nonWeekendHolidays;
    }

    protected static boolean isWeekend(Double aDate) {
        Calendar date = LocaleUtil.getLocaleCalendar();
        date.setTime(DateUtil.getJavaDate(aDate));
        return date.get(7) == 7 || date.get(7) == 1;
    }

    protected static boolean isHoliday(Double aDate, Double[] holidays) {
        if (null == holidays || holidays.length < 1) {
            return false;
        }
        Double[] doubleArray = holidays;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double holiday = doubleArray[i];
            if (Math.round(holiday) != Math.round(aDate)) continue;
            return true;
        }
        return false;
    }

    protected static int isNonWorkday(Double aDate, Double[] holidays) {
        return CalculatorNetWorkdays.isWeekend(aDate) || CalculatorNetWorkdays.isHoliday(aDate, holidays) ? 1 : 0;
    }

    protected static boolean isInARange(Double start, Double end, Double aDate) {
        return aDate >= start && aDate <= end;
    }
}

