/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dateandtime;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.Features;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.usermodel.DateUtil;

public final class CalculatorDateValue
extends CalculatorBase {
    static int MIN_DATE_TIME_LEN = 5;
    private static String[] commonDateTemplates = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss,a", "yyyy-MM-dd HH:mm", "yyyy-MM-dd'T'HH:mm:ss.SSSZZ", "dd-MM-yyyy HH:mm a", "dd/MMM/yyyy HH:mm:ss Z", "dd/MMM/yyyy HH:mm", "yyyy-MM-dd", "//dd/MM/yyyy", "dd MMM yyyy", "dd/MMM/yy", "yyyy-MM-dd", "dd-MMM-yyyy", "dd.MM.yyyy HH:mm:ss", "dd.MM.yyyy HH:mm"};

    public CalculatorDateValue(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckParams(objParams, 1);
        Locale locale = Locale.US;
        Object objParam = Conversion.sanitizeFromVariableValue(objParams[0]);
        if (null == objParam || objParam.toString().trim().isEmpty()) {
            Date now = new Date(System.currentTimeMillis());
            double res = DateUtil.getExcelDate(now);
            return Features.RETURN_MINUS_ONE_FROM_DATEVALUE ? new Long(-1L) : new DateTime(res);
        }
        if (Features.CHECK_ON_DATETIME_IN_DATEVALUE_FUNC && objParam instanceof DateTime) {
            return (DateTime)objParam;
        }
        String strParam = "";
        strParam = CalculatorDateValue.trimDateString(objParam.toString());
        try {
            DateTime res = CalculatorDateValue.parseDate(strParam.trim(), locale);
            return res;
        }
        catch (IllegalArgumentException e) {
            if (Features.RETURN_MINUS_ONE_FROM_DATEVALUE) {
                return new Long(-1L);
            }
            throw e;
        }
        catch (Exception e) {
            if (Features.RETURN_MINUS_ONE_FROM_DATEVALUE) {
                return new Long(-1L);
            }
            Date now = new Date(System.currentTimeMillis());
            double res = DateUtil.getExcelDate(now);
            return new DateTime(res);
        }
    }

    public static boolean isDateTime(Object objParameter) {
        double dVal;
        Date date;
        Locale locale = Locale.US;
        Object objParam = Conversion.sanitizeFromVariableValue(objParameter);
        if (null == objParam || objParam.toString().trim().isEmpty()) {
            return false;
        }
        if (Features.DOUBLE_DATES_SUPPORT && objParam instanceof Double && null != (date = DateUtil.getJavaDate(dVal = ((Double)objParam).doubleValue())) && date.getYear() < 3000) {
            return true;
        }
        String strParam = "";
        strParam = objParam.toString();
        if (Features.CHECK_FOR_STRING_LEN_IN_DATE_PARSING && strParam.length() < MIN_DATE_TIME_LEN) {
            return false;
        }
        String strVal = CalculatorDateValue.trimDateString(strParam);
        try {
            DateTime res = CalculatorDateValue.parseDate(strVal.trim(), locale);
            return null != res;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static String trimDateString(String strVal) {
        int end;
        int start;
        String result = "";
        int len = null == strVal ? 0 : strVal.length();
        for (start = 0; start < len && !Character.isLetter(strVal.charAt(start)) && !Character.isDigit(strVal.charAt(start)); ++start) {
        }
        if (start >= len) {
            return "";
        }
        for (end = len - 1; end >= 0 && !Character.isLetter(strVal.charAt(end)) && !Character.isDigit(strVal.charAt(end)); --end) {
        }
        if (end < 0) {
            return "";
        }
        result = strVal.substring(start, end + 1);
        return result;
    }

    protected static DateTime parseDate(String strVal, Locale locale) throws EvaluationException {
        ArrayList<DateFormat> dateFormats;
        Date date = null;
        if (null == date && null != (dateFormats = CalculatorDateValue.getDateFormats(locale))) {
            DateFormat df = null;
            for (int i = 0; i < dateFormats.size(); ++i) {
                date = null;
                try {
                    df = dateFormats.get(i);
                    date = df.parse(strVal);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null != date) break;
            }
        }
        if (null == date) {
            throw new IllegalArgumentException("date");
        }
        Calendar calendar = CalculatorDateValue.toCalendar(date);
        int f0 = calendar.get(1);
        int f1 = calendar.get(2);
        int f2 = calendar.get(5);
        if (f0 < 0 || f1 < 0 || f2 < 0 || f0 > 12 && f1 > 12 && f2 > 12) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        double res = DateUtil.getExcelDate(date);
        return new DateTime(res);
    }

    public static Calendar toCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private static ArrayList<DateFormat> getDateFormats(Locale locale) {
        try {
            int j;
            int i;
            Locale[] locales = new Locale[]{locale, Locale.US, Locale.GERMAN};
            int[] dateFormatTypes = new int[]{2, 0, 1, 2, 3};
            ArrayList<DateFormat> dateFormats = new ArrayList<DateFormat>();
            for (i = 0; i < locales.length; ++i) {
                for (j = 0; j < commonDateTemplates.length; ++j) {
                    SimpleDateFormat sdf = new SimpleDateFormat(commonDateTemplates[j], locales[i]);
                    if (null == sdf) continue;
                    dateFormats.add(sdf);
                }
            }
            for (i = 0; i < locales.length; ++i) {
                for (j = 0; j < dateFormatTypes.length; ++j) {
                    for (int k = 0; k < dateFormatTypes.length; ++k) {
                        DateFormat df = DateFormat.getDateTimeInstance(dateFormatTypes[j], dateFormatTypes[k], locales[i]);
                        if (null == df) continue;
                        dateFormats.add(df);
                    }
                }
                for (j = 0; j < dateFormatTypes.length; ++j) {
                    DateFormat df = DateFormat.getDateInstance(dateFormatTypes[j], locales[i]);
                    if (null == df) continue;
                    dateFormats.add(df);
                }
                for (int k = 0; k < dateFormatTypes.length; ++k) {
                    DateFormat df = DateFormat.getTimeInstance(dateFormatTypes[k], locales[i]);
                    if (null == df) continue;
                    dateFormats.add(df);
                }
            }
            return dateFormats;
        }
        catch (Exception e) {
            return null;
        }
    }
}

