/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Compiler;
import com.celestecs.expression.Features;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.PageContentProvider;
import com.celestecs.expression.VariableRange;
import com.celestecs.expression.VariableValue;
import java.util.ArrayList;

public abstract class Variable {
    public static String EMPTY_VAR_NAME = "EmptyVarQWE123";

    public abstract VariableType getVariableType();

    public abstract Object getValue();

    public abstract String getVariableName();

    public static Object findVariableValue(String varName, ArrayList<VariableValue> variableValues) {
        for (VariableValue variableValue : variableValues) {
            if (!variableValue.getVariableName().equalsIgnoreCase(varName)) continue;
            return variableValue.getValue();
        }
        return null;
    }

    public static Variable makeVariable(String varName, ArrayList<VariableValue> variableValues, PageContentProvider pageContentProvider, MathTextResolver i18n) {
        int found;
        int startIndex = 0;
        if (Features.SPACE_AND_TITLE_FOR_SRC_PAGE && (found = varName.toLowerCase().indexOf("]Table".toLowerCase())) > -1) {
            startIndex = found + 1;
        }
        try {
            if (varName.indexOf(":", startIndex) > -1) {
                String[][] varNames = Compiler.rangeToVarNamesAsArray(varName, pageContentProvider, i18n);
                int rowCount = varNames.length;
                int colCount = varNames[0].length;
                VariableValue[][] varValues = new VariableValue[rowCount][colCount];
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < colCount; ++j) {
                        VariableValue var;
                        String name = varNames[i][j];
                        if (null == name || name.length() < 1) {
                            VariableValue var2;
                            varValues[i][j] = var2 = new VariableValue(EMPTY_VAR_NAME, "");
                            continue;
                        }
                        Object value = Variable.findVariableValue(name, variableValues);
                        if (null == value) {
                            return null;
                        }
                        varValues[i][j] = var = new VariableValue(name, value);
                    }
                }
                VariableRange rangeVar = new VariableRange(varName, varValues);
                return rangeVar;
            }
            Object value = Variable.findVariableValue(varName, variableValues);
            if (null == value) {
                return null;
            }
            VariableValue var = new VariableValue(varName, value);
            return var;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum VariableType {
        VALUE,
        RANGE;

    }
}

