/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.image.writers;

import com.celestecs.confluence.image.writers.ImageWriterBase;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;

public class PngImageWriter
implements ImageWriterBase {
    @Override
    public boolean accepts(String imageFormat) {
        return "png".equalsIgnoreCase(imageFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(BufferedImage image, String imageFormat, OutputStream output, Object additionalData) throws IOException {
        ImageWriter writer;
        if (this.writeImageUsingCommonsImaging(image, output, additionalData)) {
            return true;
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(imageFormat);
        if (writers.hasNext() && (writer = writers.next()) != null) {
            ImageWriteParam params = writer.getDefaultWriteParam();
            params.setProgressiveMode(0);
            writer.setOutput(ImageIO.createImageOutputStream(output));
            try {
                writer.write(null, new IIOImage(image, null, null), params);
                boolean bl = true;
                return bl;
            }
            finally {
                writer.dispose();
                output.flush();
            }
        }
        return false;
    }

    private boolean writeImageUsingCommonsImaging(BufferedImage image, OutputStream output, Object additionalData) {
        try {
            ImageFormats format = ImageFormats.PNG;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (null != additionalData && ((String)additionalData).length() > 0) {
                params.put("XMP_XML", (String)additionalData);
            }
            Imaging.writeImage(image, output, (ImageFormat)format, params);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

