/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.image.writers;

import com.celestecs.confluence.image.writers.ImageWriterBase;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

public class JpegImageWriter
implements ImageWriterBase {
    private static final Pattern imageFormatPattern = Pattern.compile("(?i)jpe?g");

    @Override
    public boolean accepts(String imageFormat) {
        if (imageFormat == null) {
            return false;
        }
        return imageFormatPattern.matcher(imageFormat).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(BufferedImage image, String imageFormat, OutputStream output, Object additionalData) throws IOException {
        ImageWriter writer;
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(imageFormat);
        if (writers.hasNext() && (writer = writers.next()) != null) {
            ImageWriteParam params = writer.getDefaultWriteParam();
            params.setCompressionMode(2);
            params.setCompressionQuality(0.97f);
            writer.setOutput(ImageIO.createImageOutputStream(output));
            try {
                writer.write(null, new IIOImage(image, null, null), params);
                boolean bl = true;
                return bl;
            }
            finally {
                writer.dispose();
                output.flush();
            }
        }
        return false;
    }
}

