/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.image.writers;

import com.celestecs.confluence.image.writers.GifImageWriter;
import com.celestecs.confluence.image.writers.ImageWriterBase;
import com.celestecs.confluence.image.writers.JpegImageWriter;
import com.celestecs.confluence.image.writers.PngImageWriter;
import com.google.common.collect.ImmutableList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageWriter {
    private static final List<ImageWriterBase> customImageWriters = ImmutableList.of((Object)new JpegImageWriter(), (Object)new PngImageWriter(), (Object)new GifImageWriter());

    public void write(BufferedImage image, String imageFormat, OutputStream output, Object additionalData) throws IOException {
        for (ImageWriterBase writer : customImageWriters) {
            if (!writer.accepts(imageFormat) || !writer.write(image, imageFormat, output, additionalData)) continue;
            return;
        }
        ImageIO.write((RenderedImage)image, imageFormat, output);
    }
}

