/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.image;

import com.atlassian.confluence.pages.Attachment;
import com.celestecs.confluence.image.exceptions.ErrorReadingFileMetadataException;
import com.celestecs.confluence.image.exceptions.OrientationTagNotFoundException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImagingOpException;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import mediautil.image.jpeg.Exif;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShort;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;

public class MetadataWorks {
    public static final TagInfoShort tag_ORIENTATION = TiffTagConstants.TIFF_TAG_ORIENTATION;
    private static List<TagPair> fieldsToEachange = Arrays.asList(new TagPair(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, TiffTagConstants.TIFF_TAG_IMAGE_LENGTH), new TagPair(TiffTagConstants.TIFF_TAG_XRESOLUTION, TiffTagConstants.TIFF_TAG_YRESOLUTION), new TagPair(ExifTagConstants.EXIF_TAG_FOCAL_PLANE_XRESOLUTION_EXIF_IFD, ExifTagConstants.EXIF_TAG_FOCAL_PLANE_YRESOLUTION_EXIF_IFD), new TagPair(ExifTagConstants.EXIF_TAG_EXIF_IMAGE_WIDTH, ExifTagConstants.EXIF_TAG_EXIF_IMAGE_LENGTH));

    static RotationType intToRotationType(int intValue) {
        switch (intValue) {
            case -1: {
                return RotationType.RT_CounterClockwise;
            }
            case 0: {
                return RotationType.RT_Auto;
            }
            case 1: {
                return RotationType.RT_Clockwise;
            }
        }
        return RotationType.RT_Auto;
    }

    static int rotationToLLJTranRot(Rotation rotation) {
        switch (rotation) {
            case R_90: {
                return 5;
            }
            case R_180: {
                return 6;
            }
            case R_270: {
                return 7;
            }
        }
        return 0;
    }

    static int rotationToDegrees(Rotation rotation) {
        switch (rotation) {
            case R_90: {
                return 90;
            }
            case R_180: {
                return 180;
            }
            case R_270: {
                return 270;
            }
        }
        return 0;
    }

    static Rotation calcRotationToFixOrientation(int orientation) {
        switch (orientation) {
            case 1: {
                return Rotation.R_0;
            }
            case 6: {
                return Rotation.R_90;
            }
            case 3: {
                return Rotation.R_180;
            }
            case 8: {
                return Rotation.R_270;
            }
        }
        return Rotation.R_0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TiffOutputSet getExifDataFromAttachment(Attachment attachment, Rotation rotation, String rotatedImageFilePath) {
        InputStream sourceImageInputStream = null;
        TiffOutputSet tiffOutputSet = null;
        try {
            sourceImageInputStream = attachment.getContentsAsStream();
            tiffOutputSet = MetadataWorks.getExifData(sourceImageInputStream, rotation, rotatedImageFilePath);
        }
        catch (Exception e) {
            tiffOutputSet = null;
        }
        finally {
            MetadataWorks.closeQuietly(sourceImageInputStream);
            sourceImageInputStream = null;
        }
        return tiffOutputSet;
    }

    protected static void checkIfNull(Object o, String message) throws Exception {
        if (null == o) {
            throw new Exception(message);
        }
    }

    public static short readExifOrientationFromAttachment(Attachment attachment) throws OrientationTagNotFoundException, ErrorReadingFileMetadataException {
        InputStream sourceImageInputStream = null;
        TiffImageMetadata tiffImageMetadata = null;
        TiffOutputSet tiffOutputSet = null;
        TiffOutputDirectory tiffOutputDirectory = null;
        boolean foundOrientation = false;
        short orientation = 1;
        try {
            sourceImageInputStream = attachment.getContentsAsStream();
            MetadataWorks.checkIfNull(sourceImageInputStream, "Error reading attachment");
            ImageMetadata imageMetadata = Imaging.getMetadata(sourceImageInputStream, attachment.getFileName());
            MetadataWorks.checkIfNull(imageMetadata, "Error reading file metadata");
            JpegImageMetadata jpegImageMetadata = (JpegImageMetadata)imageMetadata;
            MetadataWorks.checkIfNull(jpegImageMetadata, "Error reading jpeg medatada");
            tiffImageMetadata = jpegImageMetadata.getExif();
            MetadataWorks.checkIfNull(tiffImageMetadata, "Error reading EXIF data");
            tiffOutputSet = tiffImageMetadata.getOutputSet();
            MetadataWorks.checkIfNull(tiffOutputSet, "Error working with EXIF");
            List<TiffOutputDirectory> directories = tiffOutputSet.getDirectories();
            int dirCount = null == directories ? 0 : directories.size();
            for (int k = 0; k < dirCount; ++k) {
                tiffOutputDirectory = directories.get(k);
                try {
                    TiffOutputField fieldOrientation = tiffOutputDirectory.findField(TiffTagConstants.TIFF_TAG_ORIENTATION);
                    TiffField fieldOrientationValue = jpegImageMetadata.findEXIFValueWithExactMatch(TiffTagConstants.TIFF_TAG_ORIENTATION);
                    if (null == fieldOrientation || null == fieldOrientationValue) continue;
                    orientation = (short)fieldOrientationValue.getIntValue();
                    foundOrientation = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!foundOrientation) {
                throw new OrientationTagNotFoundException();
            }
        }
        catch (Exception e) {
            throw new ErrorReadingFileMetadataException(e.getMessage());
        }
        finally {
            MetadataWorks.closeQuietly(sourceImageInputStream);
            sourceImageInputStream = null;
        }
        return orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXmpDataFromAttachment(Attachment attachment, String rotatedImageFilePath) {
        InputStream sourceImageInputStream = null;
        String result = null;
        try {
            sourceImageInputStream = attachment.getContentsAsStream();
            if (null != sourceImageInputStream) {
                result = Imaging.getXmpXml(sourceImageInputStream, rotatedImageFilePath);
            }
        }
        catch (Exception e) {
            result = null;
        }
        finally {
            MetadataWorks.closeQuietly(sourceImageInputStream);
            sourceImageInputStream = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhotoshopApp13Data getIptcDataFromAttachment(Attachment attachment, String rotatedImageFilePath) {
        InputStream sourceImageInputStream = null;
        PhotoshopApp13Data result = null;
        try {
            JpegPhotoshopMetadata jpegPhotoshopMetadata;
            JpegImageMetadata jpegImageMetadata;
            ImageMetadata imageMetadata;
            sourceImageInputStream = attachment.getContentsAsStream();
            if (null != sourceImageInputStream && null != (imageMetadata = Imaging.getMetadata(sourceImageInputStream, rotatedImageFilePath)) && null != (jpegImageMetadata = (JpegImageMetadata)imageMetadata) && null != (jpegPhotoshopMetadata = jpegImageMetadata.getPhotoshop())) {
                result = jpegPhotoshopMetadata.photoshopApp13Data;
            }
        }
        catch (Exception e) {
            result = null;
        }
        finally {
            MetadataWorks.closeQuietly(sourceImageInputStream);
            sourceImageInputStream = null;
        }
        return result;
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TiffOutputSet getExifData(InputStream sourceFile, Rotation rotation, String rotatedImageFilePath) {
        TiffOutputSet sourceSet;
        block7: {
            sourceSet = MetadataWorks.getOutputSetWithUpdatedExif(sourceFile, rotatedImageFilePath, TiffConstants.DEFAULT_TIFF_BYTE_ORDER, rotation);
            if (null != sourceSet && sourceSet.getDirectories() != null && !sourceSet.getDirectories().isEmpty()) break block7;
            TiffOutputSet tiffOutputSet = null;
            return tiffOutputSet;
        }
        try {
            TiffOutputSet destSet = MetadataWorks.getOutputSet(rotatedImageFilePath, sourceSet.byteOrder);
            List<TiffOutputDirectory> sourceDirectories = sourceSet.getDirectories();
            int count = sourceDirectories.size();
            for (int i = 0; i < count; ++i) {
                TiffOutputDirectory sourceDirectory = sourceDirectories.get(i);
                TiffOutputDirectory destinationDirectory = MetadataWorks.getOrCreateOutputDirectory(destSet, sourceDirectory);
                if (destinationDirectory == null) continue;
                List<TiffOutputField> sourceFields = sourceDirectory.getFields();
                int jCount = sourceFields.size();
                for (int j = 0; j < jCount; ++j) {
                    TiffOutputField sourceField = sourceFields.get(j);
                    if (null == sourceField) continue;
                    destinationDirectory.removeField(sourceField.tagInfo);
                    destinationDirectory.add(sourceField);
                }
            }
            TiffOutputSet tiffOutputSet = destSet;
            return tiffOutputSet;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TiffOutputSet getOutputSet(String rotatedImageFilePath, ByteOrder defaultTiffByteOrder) {
        FileInputStream imageInputStream = null;
        TiffImageMetadata exif = null;
        TiffOutputSet outputSet = null;
        try {
            imageInputStream = new FileInputStream(rotatedImageFilePath);
            ImageMetadata metadata = Imaging.getMetadata(imageInputStream, rotatedImageFilePath);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            if (jpegMetadata != null && (exif = jpegMetadata.getExif()) != null) {
                outputSet = exif.getOutputSet();
            }
            if (outputSet == null) {
                outputSet = new TiffOutputSet(defaultTiffByteOrder);
            }
        }
        catch (Exception e) {
            TiffOutputSet tiffOutputSet;
            try {
                tiffOutputSet = null;
            }
            catch (Throwable throwable) {
                MetadataWorks.closeQuietly(imageInputStream);
                throw throwable;
            }
            MetadataWorks.closeQuietly(imageInputStream);
            return tiffOutputSet;
        }
        MetadataWorks.closeQuietly(imageInputStream);
        return outputSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TiffOutputSet getOutputSetWithUpdatedExif(InputStream sourceFile, String imageFilePath, ByteOrder defaultTiffByteOrder, Rotation rotation) {
        Closeable imageInputStream = null;
        TiffImageMetadata tiffImageMetadata = null;
        TiffOutputSet tiffOutputSet = null;
        TiffOutputDirectory tiffOutputDirectory = null;
        try {
            List<TiffOutputDirectory> directories;
            ImageMetadata imageMetadata = Imaging.getMetadata(sourceFile, imageFilePath);
            JpegImageMetadata jpegImageMetadata = (JpegImageMetadata)imageMetadata;
            if (jpegImageMetadata != null && (tiffImageMetadata = jpegImageMetadata.getExif()) != null) {
                tiffOutputSet = tiffImageMetadata.getOutputSet();
            }
            if (tiffOutputSet == null) {
                tiffOutputSet = new TiffOutputSet();
            }
            int dirCount = null == (directories = tiffOutputSet.getDirectories()) ? 0 : directories.size();
            for (int k = 0; k < dirCount; ++k) {
                tiffOutputDirectory = directories.get(k);
                if (rotation == Rotation.R_90 || rotation == Rotation.R_270) {
                    int count = fieldsToEachange.size();
                    for (int i = 0; i < count; ++i) {
                        TagPair pair = fieldsToEachange.get(i);
                        if (null == pair) continue;
                        TagInfo tag1 = pair.tag1;
                        TagInfo tag2 = pair.tag2;
                        if (null == tag1 || null == tag2) continue;
                        try {
                            TiffOutputField field1 = tiffOutputDirectory.findField(tag1);
                            TiffOutputField field2 = tiffOutputDirectory.findField(tag2);
                            TiffOutputField newField1 = new TiffOutputField(field1.tagInfo, field2.fieldType, field2.count, field2.bytes);
                            TiffOutputField newField2 = new TiffOutputField(field2.tagInfo, field1.fieldType, field1.count, field1.bytes);
                            tiffOutputDirectory.removeField(tag1);
                            tiffOutputDirectory.removeField(tag2);
                            tiffOutputDirectory.add(newField1);
                            tiffOutputDirectory.add(newField2);
                            continue;
                        }
                        catch (Exception field1) {
                            // empty catch block
                        }
                    }
                }
                try {
                    TiffOutputField fieldOrientation = tiffOutputDirectory.findField(TiffTagConstants.TIFF_TAG_ORIENTATION);
                    TiffField fieldOrientationValue = jpegImageMetadata.findEXIFValueWithExactMatch(TiffTagConstants.TIFF_TAG_ORIENTATION);
                    if (null == fieldOrientation || null == fieldOrientationValue) continue;
                    short oldOrientation = (short)fieldOrientationValue.getIntValue();
                    int op = MetadataWorks.rotationToLLJTranRot(rotation);
                    int newOrientation = Exif.transformOrientationTag(oldOrientation, op);
                    byte[] newOrientationValue = TiffTagConstants.TIFF_TAG_ORIENTATION.encodeValue(defaultTiffByteOrder, (short)newOrientation);
                    TiffOutputField newFieldOrient = new TiffOutputField(fieldOrientation.tagInfo, fieldOrientation.fieldType, 1, newOrientationValue);
                    tiffOutputDirectory.removeField(TiffTagConstants.TIFF_TAG_ORIENTATION);
                    tiffOutputDirectory.add(newFieldOrient);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            MetadataWorks.closeQuietly(imageInputStream);
        }
        return tiffOutputSet;
    }

    private static TiffOutputDirectory getOrCreateOutputDirectory(TiffOutputSet outputSet, TiffOutputDirectory outputDirectory) {
        TiffOutputDirectory result = outputSet.findDirectory(outputDirectory.type);
        if (result != null) {
            return result;
        }
        result = new TiffOutputDirectory(outputDirectory.type, null);
        try {
            outputSet.addDirectory(result);
        }
        catch (ImageWriteException e) {
            return null;
        }
        return result;
    }

    public static BufferedImage apply(BufferedImage src, BufferedImageOp ... ops) throws IllegalArgumentException, ImagingOpException {
        if (src == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        if (ops == null || ops.length == 0) {
            throw new IllegalArgumentException("ops cannot be null or empty");
        }
        int type = src.getType();
        if (type != 1 && type != 2) {
            src = MetadataWorks.copyToOptimalImage(src);
        }
        boolean hasReassignedSrc = false;
        for (int i = 0; i < ops.length; ++i) {
            BufferedImageOp op = ops[i];
            if (op == null) continue;
            Rectangle2D resultBounds = op.getBounds2D(src);
            if (resultBounds == null) {
                throw new ImagingOpException("BufferedImageOp [" + op.toString() + "] getBounds2D(src) returned null bounds for the target image; this should not happen and indicates a problem with application of this type of op.");
            }
            BufferedImage dest = MetadataWorks.createOptimalImage(src, (int)Math.round(resultBounds.getWidth()), (int)Math.round(resultBounds.getHeight()));
            BufferedImage result = op.filter(src, dest);
            if (hasReassignedSrc) {
                src.flush();
            }
            src = result;
            hasReassignedSrc = true;
        }
        return src;
    }

    public static BufferedImage rotate(BufferedImage src, Rotation rotation, BufferedImageOp ... ops) throws IllegalArgumentException, ImagingOpException {
        if (src == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        if (rotation == null) {
            throw new IllegalArgumentException("rotation cannot be null");
        }
        int newWidth = src.getWidth();
        int newHeight = src.getHeight();
        AffineTransform tx = new AffineTransform();
        switch (rotation) {
            case R_90: {
                newWidth = src.getHeight();
                newHeight = src.getWidth();
                tx.translate(newWidth, 0.0);
                tx.rotate(Math.toRadians(90.0));
                break;
            }
            case R_270: {
                newWidth = src.getHeight();
                newHeight = src.getWidth();
                tx.translate(0.0, newHeight);
                tx.rotate(Math.toRadians(-90.0));
                break;
            }
            case R_180: {
                tx.translate(newWidth, newHeight);
                tx.rotate(Math.toRadians(180.0));
                break;
            }
            case R_0: {
                break;
            }
        }
        BufferedImage result = MetadataWorks.createOptimalImage(src, newWidth, newHeight);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(src, tx, null);
        g2d.dispose();
        if (ops != null && ops.length > 0) {
            result = MetadataWorks.apply(result, ops);
        }
        return result;
    }

    protected static BufferedImage createOptimalImage(BufferedImage src, int width, int height) throws IllegalArgumentException {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width [" + width + "] and height [" + height + "] must be >= 0");
        }
        return new BufferedImage(width, height, src.getTransparency() == 1 ? 1 : 2);
    }

    protected static BufferedImage copyToOptimalImage(BufferedImage src) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        int type = src.getTransparency() == 1 ? 1 : 2;
        BufferedImage result = new BufferedImage(src.getWidth(), src.getHeight(), type);
        Graphics g = result.getGraphics();
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return result;
    }

    public static enum RotationType {
        RT_CounterClockwise,
        RT_Auto,
        RT_Clockwise;

    }

    public static enum Rotation {
        R_0,
        R_90,
        R_180,
        R_270;

    }

    private static class TagPair {
        public TagInfo tag1 = null;
        public TagInfo tag2 = null;

        public TagPair(TagInfo t1, TagInfo t2) {
            this.tag1 = t1;
            this.tag2 = t2;
        }
    }
}

