/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.image;

import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugins.rest.common.security.AuthenticationContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.celestecs.confluence.image.Features;
import com.celestecs.confluence.image.MetadataWorks;
import com.celestecs.confluence.image.exceptions.AttachmentSavingException;
import com.celestecs.confluence.image.exceptions.ImageFileReadException;
import com.celestecs.confluence.image.exceptions.ImageFileWriteException;
import com.celestecs.confluence.image.exceptions.ImageRotationException;
import com.celestecs.confluence.image.exceptions.UnableToCreateTemporaryFileException;
import com.celestecs.confluence.image.writers.ImageWriter;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.Principal;
import javax.imageio.ImageIO;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import mediautil.image.jpeg.LLJTran;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.jpeg.iptc.JpegIptcRewriter;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegXmpRewriter;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.log4j.Logger;

@Path(value="/")
public class ImageLosslessRotatorRestService {
    private static final Logger LOGGER = Logger.getLogger(ImageLosslessRotatorRestService.class);
    private final AttachmentManager attachmentManager;
    private final PermissionManager permissionManager;
    private final BootstrapManager bootstrapManager;
    private final I18nResolver i18n;
    private final UserAccessor userAccessor;
    protected final PluginLicenseManager licenseManager;
    SettingsManager settingsManager;
    private final ImageWriter imageWriter = new ImageWriter();

    public ImageLosslessRotatorRestService(AttachmentManager attachmentManager, PermissionManager permissionManager, BootstrapManager bootstrapManager, I18nResolver i18n, UserAccessor userAccessor, PluginLicenseManager licenseMgr, SettingsManager settingsManager) {
        this.attachmentManager = attachmentManager;
        this.permissionManager = permissionManager;
        this.bootstrapManager = bootstrapManager;
        this.i18n = i18n;
        this.userAccessor = userAccessor;
        this.licenseManager = licenseMgr;
        this.settingsManager = settingsManager;
    }

    /*
     * Exception decompiling
     */
    @GET
    @Path(value="/rotate")
    public Response rotate(@QueryParam(value="attachmentId") int attachmentId, @QueryParam(value="rotationType") int intRotationType, @Context AuthenticationContext authenticationContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File createTempFile(String fileName, String fileExtension) throws UnableToCreateTemporaryFileException {
        File tmpFile = null;
        try {
            File tempDirectory = new File(this.bootstrapManager.getConfluenceHome(), "temp");
            tmpFile = File.createTempFile(fileName, fileExtension, tempDirectory);
        }
        catch (Exception e) {
            try {
                tmpFile = File.createTempFile(fileName, fileExtension);
            }
            catch (Exception e1) {
                tmpFile = null;
            }
        }
        if (null == tmpFile) {
            throw new UnableToCreateTemporaryFileException();
        }
        return tmpFile;
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getUserNameFromContext(AuthenticationContext context) {
        if (context == null) {
            return null;
        }
        Principal principal = context.getPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    private User findUserByName(String userName) {
        return this.userAccessor.getUser(userName);
    }

    private boolean isUserAuthorizedToEditAttachment(User user, Attachment attachment) {
        return user != null && this.permissionManager.hasPermission(user, Permission.EDIT, (Object)attachment);
    }

    private void rotateImageLossless(Attachment attachment, MetadataWorks.Rotation rotation, String dstFilePath) throws Exception {
        File dstFile = null;
        FileOutputStream dstOutputStream = null;
        InputStream sourceImageInputStream = null;
        LLJTran llj = null;
        try {
            sourceImageInputStream = attachment.getContentsAsStream();
            llj = new LLJTran(sourceImageInputStream);
            llj.read(3, true);
            int options = 793;
            int op = MetadataWorks.rotationToLLJTranRot(rotation);
            llj.transform(op, options);
            dstFile = new File(dstFilePath);
            dstFile.createNewFile();
            dstOutputStream = new FileOutputStream(dstFile);
            llj.save(dstOutputStream, 768);
            this.closeQuietly(sourceImageInputStream);
            this.closeQuietly(dstOutputStream);
            if (llj != null) {
                llj.freeMemory();
                llj = null;
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.closeQuietly(sourceImageInputStream);
                this.closeQuietly(dstOutputStream);
                if (llj != null) {
                    llj.freeMemory();
                    llj = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rotateImageLossy(Attachment attachment, MetadataWorks.Rotation rotation, String dstFilePath) throws ImageFileReadException, ImageFileWriteException, ImageRotationException {
        FileOutputStream result = null;
        InputStream sourceImageInputStream = null;
        boolean fileIsRead = false;
        try {
            Object additionalData = null;
            sourceImageInputStream = attachment.getContentsAsStream();
            BufferedImage image = ImageIO.read(sourceImageInputStream);
            fileIsRead = true;
            image = MetadataWorks.rotate(image, rotation, new BufferedImageOp[0]);
            String imageFormat = attachment.getFileExtension();
            result = new FileOutputStream(dstFilePath);
            this.imageWriter.write(image, imageFormat, result, additionalData);
        }
        catch (IOException e) {
            try {
                RuntimeException runtimeException;
                if (fileIsRead) {
                    runtimeException = new ImageFileWriteException();
                    throw runtimeException;
                }
                runtimeException = new ImageFileReadException();
                throw runtimeException;
                catch (IllegalArgumentException e2) {
                    throw new ImageRotationException();
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(sourceImageInputStream);
                this.closeQuietly(result);
                throw throwable;
            }
        }
        this.closeQuietly(sourceImageInputStream);
        this.closeQuietly(result);
    }

    private void copyMetadataToJpeg(Attachment attachment, MetadataWorks.Rotation rotation, String dstFilePath) throws UnableToCreateTemporaryFileException {
        TiffOutputSet tiffOutputSet;
        String xmpXml;
        ExifRewriter exifRewriter = null;
        JpegIptcRewriter iptcRewriter = null;
        JpegXmpRewriter jpegXmpRewriter = null;
        FileOutputStream out = null;
        FileInputStream in = null;
        File newTempFile = null;
        newTempFile = this.createTempFile(attachment.getFileName(), "." + attachment.getFileExtension());
        PhotoshopApp13Data jpegPhotoshopMetadata = MetadataWorks.getIptcDataFromAttachment(attachment, dstFilePath);
        if (null != jpegPhotoshopMetadata) {
            try {
                out = new FileOutputStream(newTempFile);
                in = new FileInputStream(dstFilePath);
                iptcRewriter = new JpegIptcRewriter();
                iptcRewriter.writeIPTC(in, (OutputStream)out, jpegPhotoshopMetadata);
                this.closeQuietly(in);
                in = null;
                this.closeQuietly(out);
                out = null;
                java.nio.file.Path from = Paths.get(newTempFile.getAbsolutePath(), new String[0]);
                java.nio.file.Path to = Paths.get(dstFilePath, new String[0]);
                Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception from) {
                // empty catch block
            }
        }
        if (null != (xmpXml = MetadataWorks.getXmpDataFromAttachment(attachment, dstFilePath)) && "" != xmpXml) {
            try {
                out = new FileOutputStream(newTempFile);
                in = new FileInputStream(dstFilePath);
                jpegXmpRewriter = new JpegXmpRewriter();
                jpegXmpRewriter.updateXmpXml(in, (OutputStream)out, xmpXml);
                this.closeQuietly(in);
                in = null;
                this.closeQuietly(out);
                out = null;
                java.nio.file.Path from = Paths.get(newTempFile.getAbsolutePath(), new String[0]);
                java.nio.file.Path to = Paths.get(dstFilePath, new String[0]);
                Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception from) {
                // empty catch block
            }
        }
        if (null != (tiffOutputSet = MetadataWorks.getExifDataFromAttachment(attachment, rotation, dstFilePath))) {
            try {
                out = new FileOutputStream(newTempFile);
                in = new FileInputStream(dstFilePath);
                exifRewriter = new ExifRewriter();
                exifRewriter.updateExifMetadataLossless(in, (OutputStream)out, tiffOutputSet);
                this.closeQuietly(in);
                in = null;
                this.closeQuietly(out);
                out = null;
                java.nio.file.Path from = Paths.get(newTempFile.getAbsolutePath(), new String[0]);
                java.nio.file.Path to = Paths.get(dstFilePath, new String[0]);
                Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closeQuietly(in);
        in = null;
        this.closeQuietly(out);
        out = null;
        if (newTempFile != null && newTempFile.exists()) {
            try {
                newTempFile.delete();
                newTempFile = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void getRotatedImageAsStream(Attachment attachment, MetadataWorks.Rotation rotation, String filePath) throws ImageFileReadException, ImageFileWriteException, ImageRotationException, UnableToCreateTemporaryFileException {
        try {
            this.rotateImageLossless(attachment, rotation, filePath);
        }
        catch (Exception e) {
            this.rotateImageLossy(attachment, rotation, filePath);
        }
        String fileExtension = attachment.getFileExtension();
        if (0 == fileExtension.compareToIgnoreCase("jpg") || 0 == fileExtension.compareToIgnoreCase("jpeg") || 0 == fileExtension.compareToIgnoreCase("jfif")) {
            this.copyMetadataToJpeg(attachment, rotation, filePath);
        }
    }

    private void saveNewVersionOfAttachment(Attachment attachment, String newFilePath, String newComment) throws AttachmentSavingException {
        FileInputStream newStream = null;
        String oldComment = attachment.getComment();
        Attachment oldAttachment = attachment.copy();
        File newFile = new File(newFilePath);
        attachment.setFileSize(newFile.length());
        if (Features.SMART_COMMENTS) {
            String ownComment1 = String.format(this.i18n.getText("com.celestecs.confluence.image-lossless-rotator.comment.clockwise"), new Object[0]);
            String ownComment2 = String.format(this.i18n.getText("com.celestecs.confluence.image-lossless-rotator.comment.counter-clockwise"), new Object[0]);
            String ownComment3 = String.format(this.i18n.getText("com.celestecs.confluence.image-lossless-rotator.comment.auto-partial"), new Object[0]);
            if (null != oldComment) {
                // empty if block
            }
            if (null == oldComment || oldComment.isEmpty() || oldComment.equalsIgnoreCase(ownComment1) || oldComment.equalsIgnoreCase(ownComment2) || oldComment.endsWith(ownComment3)) {
                attachment.setComment(newComment);
            } else {
                attachment.setComment(oldComment);
            }
        } else {
            attachment.setComment(newComment);
        }
        try {
            newStream = new FileInputStream(newFile);
            this.attachmentManager.saveAttachment(attachment, oldAttachment, (InputStream)newStream);
        }
        catch (IOException e) {
            throw new AttachmentSavingException(e.getMessage());
        }
        finally {
            this.closeQuietly(newStream);
        }
    }

    protected boolean exemptDeveloperLicense() {
        return false;
    }

    protected boolean exemptOnDemand() {
        return false;
    }

    protected void validateLicense() throws MacroExecutionException {
        boolean licenseOk;
        String reason = String.format(this.i18n.getText("com.celestecs.confluence.image-lossless-rotator.licensing.unknown-error"), new Object[0]);
        boolean bl = licenseOk = this.licenseManager != null;
        if (licenseOk) {
            try {
                licenseOk = this.licenseManager.getLicense().isDefined();
                if (licenseOk) {
                    PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                    licenseOk = pluginLicense.isValid();
                    if (!licenseOk) {
                        String errorName = ((LicenseError)pluginLicense.getError().get()).name();
                        reason = String.format(this.i18n.getText("com.celestecs.confluence.image-lossless-rotator.licensing." + errorName), new Object[0]);
                    }
                } else {
                    reason = String.format(this.i18n.getText("com.celestecs.confluence.image-lossless-rotator.licensing.no-license"), new Object[0]);
                }
            }
            catch (Exception exception) {
                licenseOk = false;
            }
        }
        if (!licenseOk && this.exemptDeveloperLicense()) {
            String type = LicenseManager.getInstance().getLicense("CONF").getLicenseType().getNewLicenseTypeName();
            boolean bl2 = licenseOk = type.equalsIgnoreCase("DEVELOPER") || type.equalsIgnoreCase("DEMONSTRATION");
        }
        if (!licenseOk && this.exemptOnDemand()) {
            String onDemand = System.getProperty("atlassian.upm.on.demand");
            boolean bl3 = licenseOk = onDemand != null && onDemand.equals("true");
        }
        if (!licenseOk) {
            throw new MacroExecutionException(String.format(this.i18n.getText("com.celestecs.confluence.image-lossless-rotator.licensing.invalid-license"), reason));
        }
    }
}

