/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.engineering;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.ErrorEval;

public class CalculatorBin2Dec
extends CalculatorBase {
    static final int HEXADECIMAL_BASE = 16;
    static final int MAX_NUMBER_OF_PLACES = 10;

    public CalculatorBin2Dec(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        String value;
        boolean isPositive;
        String unsigned;
        super.CheckParams(objParams, 1);
        super.CheckForNotHavingRanges(objParams);
        if (null == objParams[0] || null == objParams[0].toString()) {
            return 0;
        }
        String number = objParams[0].toString();
        if (number.length() < 10) {
            unsigned = number;
            isPositive = true;
        } else {
            unsigned = number.substring(1);
            isPositive = number.startsWith("0");
        }
        try {
            if (isPositive) {
                int sum = this.getDecimalValue(unsigned);
                value = String.valueOf(sum);
            } else {
                String inverted = CalculatorBin2Dec.toggleBits(unsigned);
                int sum = this.getDecimalValue(inverted);
                value = "-" + ++sum;
            }
        }
        catch (NumberFormatException e) {
            return ErrorEval.NUM_ERROR;
        }
        long result = Long.parseLong(value);
        return result;
    }

    private int getDecimalValue(String unsigned) {
        int sum = 0;
        int numBits = unsigned.length();
        int power = numBits - 1;
        for (int i = 0; i < numBits; ++i) {
            int bit = Integer.parseInt(unsigned.substring(i, i + 1));
            int term = (int)((double)bit * Math.pow(2.0, power));
            sum += term;
            --power;
        }
        return sum;
    }

    private static String toggleBits(String s) {
        long i = Long.parseLong(s, 2);
        long i2 = i ^ (1L << s.length()) - 1L;
        String s2 = Long.toBinaryString(i2);
        while (s2.length() < s.length()) {
            s2 = '0' + s2;
        }
        return s2;
    }
}

