/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.math;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.sal.api.net.Request;
import com.celestecs.expression.DateTime;
import com.celestecs.expression.Features;
import com.celestecs.expression.JiraIssueFieldDescriptor;
import com.celestecs.expression.QueryExecutor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.DateUtil;

public class MathJqlQueryExecutor
implements QueryExecutor {
    protected String DUMMY_JIRA_RESPONSE = "{\"expand\":\"schema,names\",\"startAt\":0,\"maxResults\":1000,\"total\":3,\"issues\":[{\"expand\":\"operations,versionedRepresentations,editmeta,changelog,renderedFields\",\"id\":\"10002\",\"self\":\"http://lexus:2990/jira/rest/api/2/issue/10002\",\"key\":\"TEST-3\",\"fields\":{\"issuetype\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issuetype/10000\",\"id\":\"10000\",\"description\":\"Task.\",\"iconUrl\":\"http://lexus:2990/jira/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype\",\"name\":\"Task\",\"subtask\":false,\"avatarId\":10318},\"components\":[],\"timespent\":null,\"timeoriginalestimate\":null,\"description\":null,\"project\":{\"self\":\"http://lexus:2990/jira/rest/api/2/project/10001\",\"id\":\"10001\",\"key\":\"TEST\",\"name\":\"Test\",\"projectTypeKey\":\"business\",\"avatarUrls\":{\"48x48\":\"http://lexus:2990/jira/secure/projectavatar?avatarId=10324\",\"24x24\":\"http://lexus:2990/jira/secure/projectavatar?size=small&avatarId=10324\",\"16x16\":\"http://lexus:2990/jira/secure/projectavatar?size=xsmall&avatarId=10324\",\"32x32\":\"http://lexus:2990/jira/secure/projectavatar?size=medium&avatarId=10324\"}},\"fixVersions\":[],\"aggregatetimespent\":null,\"resolution\":null,\"aggregatetimeestimate\":null,\"resolutiondate\":null,\"workratio\":-1,\"summary\":\"Task 3\",\"lastViewed\":\"2021-06-21T22:09:13.905+0300\",\"watches\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-3/watchers\",\"watchCount\":1,\"isWatching\":true},\"creator\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"subtasks\":[],\"created\":\"2021-05-30T23:40:37.000+0300\",\"reporter\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"aggregateprogress\":{\"progress\":0,\"total\":0},\"priority\":{\"self\":\"http://lexus:2990/jira/rest/api/2/priority/3\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/priorities/medium.svg\",\"name\":\"Medium\",\"id\":\"3\"},\"labels\":[],\"environment\":null,\"timeestimate\":null,\"aggregatetimeoriginalestimate\":null,\"versions\":[],\"duedate\":null,\"progress\":{\"progress\":0,\"total\":0},\"issuelinks\":[],\"votes\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-3/votes\",\"votes\":0,\"hasVoted\":false},\"assignee\":null,\"updated\":\"2021-05-30T23:40:37.000+0300\",\"status\":{\"self\":\"http://lexus:2990/jira/rest/api/2/status/10000\",\"description\":\"\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/status_generic.gif\",\"name\":\"To Do\",\"id\":\"10000\",\"statusCategory\":{\"self\":\"http://lexus:2990/jira/rest/api/2/statuscategory/2\",\"id\":2,\"key\":\"new\",\"colorName\":\"blue-gray\",\"name\":\"To Do\"}}}},{\"expand\":\"operations,versionedRepresentations,editmeta,changelog,renderedFields\",\"id\":\"10001\",\"self\":\"http://lexus:2990/jira/rest/api/2/issue/10001\",\"key\":\"TEST-2\",\"fields\":{\"issuetype\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issuetype/10000\",\"id\":\"10000\",\"description\":\"Task.\",\"iconUrl\":\"http://lexus:2990/jira/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype\",\"name\":\"Task\",\"subtask\":false,\"avatarId\":10318},\"components\":[],\"timespent\":null,\"timeoriginalestimate\":null,\"description\":null,\"project\":{\"self\":\"http://lexus:2990/jira/rest/api/2/project/10001\",\"id\":\"10001\",\"key\":\"TEST\",\"name\":\"Test\",\"projectTypeKey\":\"business\",\"avatarUrls\":{\"48x48\":\"http://lexus:2990/jira/secure/projectavatar?avatarId=10324\",\"24x24\":\"http://lexus:2990/jira/secure/projectavatar?size=small&avatarId=10324\",\"16x16\":\"http://lexus:2990/jira/secure/projectavatar?size=xsmall&avatarId=10324\",\"32x32\":\"http://lexus:2990/jira/secure/projectavatar?size=medium&avatarId=10324\"}},\"fixVersions\":[],\"aggregatetimespent\":null,\"resolution\":null,\"aggregatetimeestimate\":null,\"resolutiondate\":null,\"workratio\":-1,\"summary\":\"Task 2\",\"lastViewed\":\"2021-05-30T23:40:32.448+0300\",\"watches\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-2/watchers\",\"watchCount\":1,\"isWatching\":true},\"creator\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"subtasks\":[],\"created\":\"2021-05-30T23:40:32.000+0300\",\"reporter\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"aggregateprogress\":{\"progress\":0,\"total\":0},\"priority\":{\"self\":\"http://lexus:2990/jira/rest/api/2/priority/3\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/priorities/medium.svg\",\"name\":\"Medium\",\"id\":\"3\"},\"labels\":[],\"environment\":null,\"timeestimate\":null,\"aggregatetimeoriginalestimate\":null,\"versions\":[],\"duedate\":null,\"progress\":{\"progress\":0,\"total\":0},\"issuelinks\":[],\"votes\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-2/votes\",\"votes\":0,\"hasVoted\":false},\"assignee\":null,\"updated\":\"2021-05-30T23:40:32.000+0300\",\"status\":{\"self\":\"http://lexus:2990/jira/rest/api/2/status/10000\",\"description\":\"\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/status_generic.gif\",\"name\":\"To Do\",\"id\":\"10000\",\"statusCategory\":{\"self\":\"http://lexus:2990/jira/rest/api/2/statuscategory/2\",\"id\":2,\"key\":\"new\",\"colorName\":\"blue-gray\",\"name\":\"To Do\"}}}},{\"expand\":\"operations,versionedRepresentations,editmeta,changelog,renderedFields\",\"id\":\"10000\",\"self\":\"http://lexus:2990/jira/rest/api/2/issue/10000\",\"key\":\"TEST-1\",\"fields\":{\"issuetype\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issuetype/10000\",\"id\":\"10000\",\"description\":\"Task.\",\"iconUrl\":\"http://lexus:2990/jira/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype\",\"name\":\"Task\",\"subtask\":false,\"avatarId\":10318},\"components\":[],\"timespent\":null,\"timeoriginalestimate\":null,\"description\":null,\"project\":{\"self\":\"http://lexus:2990/jira/rest/api/2/project/10001\",\"id\":\"10001\",\"key\":\"TEST\",\"name\":\"Test\",\"projectTypeKey\":\"business\",\"avatarUrls\":{\"48x48\":\"http://lexus:2990/jira/secure/projectavatar?avatarId=10324\",\"24x24\":\"http://lexus:2990/jira/secure/projectavatar?size=small&avatarId=10324\",\"16x16\":\"http://lexus:2990/jira/secure/projectavatar?size=xsmall&avatarId=10324\",\"32x32\":\"http://lexus:2990/jira/secure/projectavatar?size=medium&avatarId=10324\"}},\"fixVersions\":[],\"aggregatetimespent\":null,\"resolution\":null,\"aggregatetimeestimate\":null,\"resolutiondate\":null,\"workratio\":-1,\"summary\":\"Task 1\",\"lastViewed\":\"2021-05-30T23:40:21.025+0300\",\"watches\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-1/watchers\",\"watchCount\":1,\"isWatching\":true},\"creator\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"subtasks\":[],\"created\":\"2021-05-30T23:40:18.000+0300\",\"reporter\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"aggregateprogress\":{\"progress\":0,\"total\":0},\"priority\":{\"self\":\"http://lexus:2990/jira/rest/api/2/priority/3\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/priorities/medium.svg\",\"name\":\"Medium\",\"id\":\"3\"},\"labels\":[],\"environment\":null,\"timeestimate\":null,\"aggregatetimeoriginalestimate\":null,\"versions\":[],\"duedate\":null,\"progress\":{\"progress\":0,\"total\":0},\"issuelinks\":[],\"votes\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-1/votes\",\"votes\":0,\"hasVoted\":false},\"assignee\":null,\"updated\":\"2021-05-30T23:40:18.000+0300\",\"status\":{\"self\":\"http://lexus:2990/jira/rest/api/2/status/10000\",\"description\":\"\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/status_generic.gif\",\"name\":\"To Do\",\"id\":\"10000\",\"statusCategory\":{\"self\":\"http://lexus:2990/jira/rest/api/2/statuscategory/2\",\"id\":2,\"key\":\"new\",\"colorName\":\"blue-gray\",\"name\":\"To Do\"}}}},{\"expand\": \"operations,versionedRepresentations,editmeta,changelog,renderedFields\",\"id\": \"10000\",\"self\": \"http://lexus:2990/jira/rest/api/2/issue/10000\",\"key\": \"TEST-1\",\"fields\": {\"issuetype\": {\"self\": \"http://lexus:2990/jira/rest/api/2/issuetype/10000\",\"id\": \"10000\",\"description\": \"Task.\",\"iconUrl\": \"http://lexus:2990/jira/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype\",\"name\": \"Task\",\"subtask\": false,\"avatarId\": 10318},\"components\": [],\"timespent\": null,\"timeoriginalestimate\": null,\"description\": null,\"project\": {\"self\": \"http://lexus:2990/jira/rest/api/2/project/10001\",\"id\": \"10001\",\"key\": \"TEST\",\"name\": \"Test\",\"projectTypeKey\": \"business\",\"avatarUrls\": {\"48x48\": \"http://lexus:2990/jira/secure/projectavatar?avatarId=10324\",\"24x24\": \"http://lexus:2990/jira/secure/projectavatar?size=small&avatarId=10324\",\"16x16\": \"http://lexus:2990/jira/secure/projectavatar?size=xsmall&avatarId=10324\",\"32x32\": \"http://lexus:2990/jira/secure/projectavatar?size=medium&avatarId=10324\"}},\"fixVersions\": [],\"aggregatetimespent\": null,\"resolution\": null,\"aggregatetimeestimate\": null,\"resolutiondate\": null,\"workratio\": -1,\"summary\": \"Task 1\",\"lastViewed\": \"2021-05-30T23:40:21.025+0300\",\"watches\": {\"self\": \"http://lexus:2990/jira/rest/api/2/issue/TEST-1/watchers\",\"watchCount\": 1,\"isWatching\": true},\"creator\": {\"self\": \"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\": \"admin\",\"key\": \"admin\",\"emailAddress\": \"admin@admin.com\",\"avatarUrls\": {\"48x48\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\": \"admin\",\"active\": true,\"timeZone\": \"Europe/Moscow\"},\"subtasks\": [],\"created\": \"2021-05-30T23:40:18.000+0300\",\"reporter\": {\"self\": \"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\": \"admin\",\"key\": \"admin\",\"emailAddress\": \"admin@admin.com\",\"avatarUrls\": {\"48x48\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\": \"admin\",\"active\": true,\"timeZone\": \"Europe/Moscow\"},\"aggregateprogress\": {\"progress\": 0,\"total\": 0},\"priority\": {\"self\": \"http://lexus:2990/jira/rest/api/2/priority/3\",\"iconUrl\": \"http://lexus:2990/jira/images/icons/priorities/medium.svg\",\"name\": \"Medium\",\"id\": \"3\"},\"labels\": [],\"environment\": null,\"timeestimate\": null,\"aggregatetimeoriginalestimate\": null,\"versions\": [],\"duedate\": null,\"progress\": {\"progress\": 0,\"total\": 0},\"issuelinks\": [],\"votes\": {\"self\": \"http://lexus:2990/jira/rest/api/2/issue/TEST-1/votes\",\"votes\": 0,\"hasVoted\": false},\"assignee\": null,\"updated\": \"2021-05-30T23:40:18.000+0300\",\"status\": {\"self\": \"http://lexus:2990/jira/rest/api/2/status/10000\",\"description\": \"\",\"iconUrl\": \"http://lexus:2990/jira/images/icons/status_generic.gif\",\"name\": \"To Do\",\"id\": \"10000\",\"statusCategory\": {\"self\": \"http://lexus:2990/jira/rest/api/2/statuscategory/2\",\"id\": 2,\"key\": \"new\",\"colorName\": \"blue-gray\",\"name\": \"To Do\"}}}}]}";
    protected final ApplicationLinkService applicationLinkService;

    public MathJqlQueryExecutor(ApplicationLinkService _applicationLinkService) {
        this.applicationLinkService = _applicationLinkService;
    }

    @Override
    public long getNumberOfResults(String jqlRequest, String appLinkName) throws Exception {
        String strTotal;
        ApplicationLink appLink = this.getAppLink(appLinkName);
        String applicationUrl = Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        String apiPath = applicationUrl + "/rest/api/2/search?jql=" + URLEncoder.encode(jqlRequest, StandardCharsets.UTF_8.toString());
        apiPath = apiPath + "&fields=id";
        String jsRoot = "";
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, apiPath);
        request.addHeader("Content-Type", "application/json");
        if (Features.JQL_QUERY_RETURN_EMPTY_ARRAY_ON_EXCEPTION) {
            try {
                jsRoot = request.execute();
            }
            catch (Exception exception) {}
        } else {
            jsRoot = request.execute();
        }
        if (null == (strTotal = MathJqlQueryExecutor.extractValueFromJsonString(jsRoot, "total")) || strTotal.isEmpty()) {
            throw new Exception("Unable to retrieve the 'total' field value from the REST API 'search' function result.");
        }
        long intTotal = Long.parseLong(strTotal);
        return intTotal;
    }

    public static String extractValueFromJsonString(String jsonString, String varName) throws ParseException, JsonParseException {
        JsonElement objElem = JsonParser.parseString(jsonString);
        return MathJqlQueryExecutor.extractValueFromJsonElement(objElem, varName);
    }

    public static String extractValueFromJsonElement(JsonElement objRoot, String varName) throws ParseException, JsonParseException {
        if (Features.REPLACE_MINIDEV_WITH_GSON) {
            if (objRoot.isJsonObject()) {
                JsonObject rootObj = objRoot.getAsJsonObject();
                JsonElement objResult = rootObj.get(varName);
                if (null == objResult) {
                    return "";
                }
                String result = "";
                if (Features.CLOUD_FIX_GETASSTRING) {
                    result = objResult.toString();
                    if (result.length() > 1 && result.charAt(0) == '\"' && result.charAt(result.length() - 1) == '\"') {
                        result = result.substring(1, result.length() - 1);
                    }
                } else {
                    result = objResult.getAsString();
                }
                return result;
            }
            if (objRoot.isJsonArray()) {
                JsonArray rootArray = objRoot.getAsJsonArray();
                int count = rootArray.size();
                for (int i = 0; i < count; ++i) {
                    JsonObject rootObj;
                    JsonElement objItem = rootArray.get(i);
                    if (null == objItem || !objItem.isJsonObject() || !objItem.isJsonObject() || !(rootObj = objItem.getAsJsonObject()).has(varName)) continue;
                    JsonElement objResult = rootObj.get(varName);
                    if (null != objResult && objResult.isJsonObject()) {
                        JsonObject jsResult = objResult.getAsJsonObject();
                        return jsResult.toString();
                    }
                    if (null == objResult || !objResult.isJsonPrimitive()) continue;
                    String jsResult = objResult.getAsString();
                    return jsResult.toString();
                }
            }
        }
        return "";
    }

    @Override
    public Object[] getResultsByQuery(String jqlRequest, String appLinkName, long startAt, long maxResults) throws Exception {
        int count;
        ApplicationLink appLink;
        String fields = "";
        if (null != jqlRequest && jqlRequest.indexOf(Features.UNIQUE_SEPARATOR) > -1) {
            String req = jqlRequest;
            jqlRequest = req.substring(0, req.indexOf(Features.UNIQUE_SEPARATOR));
            fields = req.substring(req.indexOf(Features.UNIQUE_SEPARATOR) + Features.UNIQUE_SEPARATOR.length(), req.length());
        }
        if (null != fields && fields.length() > 0 && !fields.matches("^[0-9a-zA-Z.\\-\\*]+(,[0-9a-zA-Z.\\-\\*]+)*$")) {
            throw new Exception("The specified field list '" + fields + "' looks to be incorrect. Please, specify comma-separated alhanumeric names with dots, minuses and stars accepted and spaces or other symbols not accepted.");
        }
        ApplicationLink applicationLink = appLink = Features.USE_DUMMY_JIRA ? null : this.getAppLink(appLinkName);
        if (null == appLink && !Features.USE_DUMMY_JIRA) {
            throw new Exception("Unable to open appliction link with name '" + appLinkName + "'.");
        }
        ArrayList<JsonElement> result = new ArrayList<JsonElement>();
        String applicationUrl = Features.USE_DUMMY_JIRA || Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = Features.USE_DUMMY_JIRA ? null : appLink.createAuthenticatedRequestFactory();
        long realTotal = 0L;
        long counter = 100000L;
        for (maxResults = Math.min(1000L, maxResults); counter > 0L && maxResults >= 1L; maxResults -= (long)count) {
            String jsRoot;
            block12: {
                --counter;
                String apiPath = Features.USE_DUMMY_JIRA ? "" : applicationUrl + "/rest/api/2/search?jql=" + URLEncoder.encode(jqlRequest, StandardCharsets.UTF_8.toString());
                apiPath = apiPath + "&startAt=" + startAt;
                apiPath = apiPath + "&maxResults=" + maxResults;
                if (null != fields && fields.length() > 0) {
                    apiPath = apiPath + "&fields=" + URLEncoder.encode(fields, StandardCharsets.UTF_8.toString());
                }
                ApplicationLinkRequest request = Features.USE_DUMMY_JIRA ? null : requestFactory.createRequest(Request.MethodType.GET, apiPath);
                jsRoot = "";
                if (Features.USE_DUMMY_JIRA) {
                    jsRoot = 0L == startAt ? this.DUMMY_JIRA_RESPONSE : "{\"expand\":\"schema,names\",\"startAt\":" + startAt + ",\"maxResults\":1000,\"total\":0,\"issues\":[]}";
                } else {
                    if (Features.JQL_QUERY_RETURN_EMPTY_ARRAY_ON_EXCEPTION) {
                        try {
                            jsRoot = request.execute();
                            break block12;
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    jsRoot = request.execute();
                }
            }
            JsonElement jsonnElem = MathJqlQueryExecutor.extractValueFromJsonStringAsJsonElement(jsRoot, "issues");
            if (null == jsonnElem || !jsonnElem.isJsonArray()) {
                return new Object[0];
            }
            JsonArray issueArray = jsonnElem.getAsJsonArray();
            if (null == issueArray || issueArray.size() < 1) break;
            count = issueArray.size();
            for (int i = 0; i < count; ++i) {
                JsonElement objItem = issueArray.get(i);
                if (null == objItem) continue;
                result.add(objItem);
            }
            startAt = realTotal += (long)count;
            if (realTotal >= maxResults) break;
        }
        return result.toArray();
    }

    public static JsonElement extractValueFromJsonStringAsJsonElement(String jsonString, String varName) throws ParseException, JsonParseException {
        JsonElement objRoot = JsonParser.parseString(jsonString);
        if (objRoot.isJsonObject()) {
            JsonObject rootObj = objRoot.getAsJsonObject();
            JsonElement objResult = rootObj.get(varName);
            return objResult;
        }
        if (objRoot.isJsonArray()) {
            JsonArray rootArray = objRoot.getAsJsonArray();
            int count = rootArray.size();
            for (int i = 0; i < count; ++i) {
                JsonObject rootObj;
                JsonElement objItem = rootArray.get(i);
                if (null == objItem || !objItem.isJsonObject() || !objItem.isJsonObject() || !(rootObj = objItem.getAsJsonObject()).has(varName)) continue;
                JsonElement objResult = rootObj.get(varName);
                return objResult;
            }
        }
        return null;
    }

    public static Object getFieldValueAsSimpleType(JsonObject jsonItem, JiraIssueFieldDescriptor fieldDescriptor) {
        String strDateTime;
        if (null == jsonItem || null == fieldDescriptor) {
            return null;
        }
        JsonElement objItem = null;
        if (fieldDescriptor.id.equalsIgnoreCase("issuekey")) {
            objItem = jsonItem.get("key");
            return MathJqlQueryExecutor.getStringFromJsonElement(objItem);
        }
        objItem = jsonItem.get("fields");
        if (null == objItem || !objItem.isJsonObject()) {
            return null;
        }
        jsonItem = objItem.getAsJsonObject();
        if (null == (objItem = jsonItem.get(fieldDescriptor.id)) || objItem.isJsonNull()) {
            return null;
        }
        if (objItem.isJsonObject()) {
            jsonItem = objItem.getAsJsonObject();
        }
        if (objItem.isJsonPrimitive() && fieldDescriptor.type.equalsIgnoreCase("number")) {
            if (fieldDescriptor.custom.toLowerCase().contains("float")) {
                return MathJqlQueryExecutor.getDoubleFromJsonElement(objItem);
            }
            return MathJqlQueryExecutor.getLongFromJsonElement(objItem);
        }
        if (objItem.isJsonPrimitive() && fieldDescriptor.type.equalsIgnoreCase("string")) {
            return MathJqlQueryExecutor.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("issuetype") || fieldDescriptor.type.equalsIgnoreCase("project") || fieldDescriptor.type.equalsIgnoreCase("resolution") || fieldDescriptor.type.equalsIgnoreCase("priority") || fieldDescriptor.type.equalsIgnoreCase("status")) {
            objItem = jsonItem.get("name");
            return MathJqlQueryExecutor.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("user")) {
            objItem = jsonItem.get("key");
            return MathJqlQueryExecutor.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("any")) {
            return MathJqlQueryExecutor.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("issuelinks")) {
            JsonElement element2 = objItem.getAsJsonObject().get("outwardIssue");
            if (null != element2 && element2.isJsonObject()) {
                element2 = element2.getAsJsonObject().getAsJsonObject().get("key");
                return MathJqlQueryExecutor.getStringFromJsonElement(element2);
            }
            element2 = objItem.getAsJsonObject().get("inwardIssue");
            if (null != element2 && element2.isJsonObject()) {
                element2 = element2.getAsJsonObject().getAsJsonObject().get("key");
                return MathJqlQueryExecutor.getStringFromJsonElement(element2);
            }
        }
        if (fieldDescriptor.type.equalsIgnoreCase("progress")) {
            objItem = jsonItem.get("total");
            Long total = MathJqlQueryExecutor.getLongFromJsonElement(objItem);
            if (0L == total) {
                return 0L;
            }
            objItem = jsonItem.get("percent");
            return MathJqlQueryExecutor.getLongFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("datetime")) {
            strDateTime = MathJqlQueryExecutor.getStringFromJsonElement(objItem);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            try {
                Date dateTime = df.parse(strDateTime);
                double excelDate = DateUtil.getExcelDate(dateTime);
                DateTime dtResult = new DateTime(excelDate);
                return dtResult;
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (fieldDescriptor.type.equalsIgnoreCase("date")) {
            strDateTime = MathJqlQueryExecutor.getStringFromJsonElement(objItem);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date dateTime = df.parse(strDateTime);
                double excelDate = DateUtil.getExcelDate(dateTime);
                DateTime dtResult = new DateTime(excelDate);
                return dtResult;
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (fieldDescriptor.type.equalsIgnoreCase("watches")) {
            objItem = objItem.getAsJsonObject().get("watchCount");
            return MathJqlQueryExecutor.getLongFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("votes")) {
            objItem = objItem.getAsJsonObject().get("votes");
            return MathJqlQueryExecutor.getLongFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("option")) {
            objItem = jsonItem.get("value");
            return MathJqlQueryExecutor.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("array") || objItem.isJsonArray()) {
            JsonArray jsonArray = objItem.getAsJsonArray();
            String strResult = "";
            int count = jsonArray.size();
            if (count < 1) {
                return null;
            }
            for (int i = 0; i < count; ++i) {
                JsonElement element2;
                JsonElement element = jsonArray.get(i);
                if (null == element || element.isJsonNull()) continue;
                if (fieldDescriptor.items.equalsIgnoreCase("version") || fieldDescriptor.items.equalsIgnoreCase("component")) {
                    element2 = element.getAsJsonObject().get("name");
                    strResult = strResult + MathJqlQueryExecutor.getStringFromJsonElement(element2);
                    strResult = strResult + (i < count - 1 ? ", " : "");
                    continue;
                }
                if (fieldDescriptor.items.equalsIgnoreCase("string")) {
                    strResult = strResult + MathJqlQueryExecutor.getStringFromJsonElement(element);
                    strResult = strResult + (i < count - 1 ? ", " : "");
                    continue;
                }
                if (fieldDescriptor.items.equalsIgnoreCase("issuelinks") && fieldDescriptor.system.equalsIgnoreCase("subtasks")) {
                    element2 = element.getAsJsonObject().get("key");
                    strResult = strResult + MathJqlQueryExecutor.getStringFromJsonElement(element2);
                    strResult = strResult + (i < count - 1 ? ", " : "");
                    continue;
                }
                if (fieldDescriptor.items.equalsIgnoreCase("issuelinks") && fieldDescriptor.system.equalsIgnoreCase("issuelinks")) {
                    JsonElement element3;
                    element2 = element.getAsJsonObject().get("outwardIssue");
                    if (null != element2 && element2.isJsonObject()) {
                        element3 = element.getAsJsonObject().get("type");
                        if (null != element3 && element3.isJsonObject()) {
                            element3 = element3.getAsJsonObject().getAsJsonObject().get("outward");
                            strResult = strResult + "(" + MathJqlQueryExecutor.getStringFromJsonElement(element3) + ") ";
                        }
                        element2 = element2.getAsJsonObject().getAsJsonObject().get("key");
                        strResult = strResult + MathJqlQueryExecutor.getStringFromJsonElement(element2);
                        strResult = strResult + (i < count - 1 ? ", " : "");
                        continue;
                    }
                    element3 = element.getAsJsonObject().get("type");
                    if (null != element3 && element3.isJsonObject()) {
                        element3 = element3.getAsJsonObject().getAsJsonObject().get("inward");
                        strResult = strResult + "(" + MathJqlQueryExecutor.getStringFromJsonElement(element3) + ") ";
                    }
                    if (null != (element2 = element.getAsJsonObject().get("inwardIssue")) && element2.isJsonObject()) {
                        element2 = element2.getAsJsonObject().getAsJsonObject().get("key");
                        strResult = strResult + MathJqlQueryExecutor.getStringFromJsonElement(element2);
                        strResult = strResult + (i < count - 1 ? ", " : "");
                        continue;
                    }
                }
                if (fieldDescriptor.items.equalsIgnoreCase("attachment")) {
                    strResult = strResult + element.toString();
                    strResult = strResult + (i < count - 1 ? ", " : "");
                    continue;
                }
                if (!fieldDescriptor.items.equalsIgnoreCase("option")) continue;
                JsonObject jsonObject2 = element.getAsJsonObject();
                JsonElement element22 = jsonObject2.get("value");
                strResult = strResult + MathJqlQueryExecutor.getStringFromJsonElement(element22);
                strResult = strResult + (i < count - 1 ? ", " : "");
            }
            return strResult;
        }
        return null;
    }

    public static Long getLongFromJsonElement(JsonElement jsonElement) {
        if (null == jsonElement) {
            return null;
        }
        Long lResult = null;
        if (jsonElement.isJsonObject()) {
            lResult = jsonElement.getAsJsonObject().getAsLong();
        }
        if (jsonElement.isJsonPrimitive()) {
            lResult = jsonElement.getAsJsonPrimitive().getAsLong();
        }
        return lResult;
    }

    public static Double getDoubleFromJsonElement(JsonElement jsonElement) {
        if (null == jsonElement) {
            return null;
        }
        Double dResult = null;
        if (jsonElement.isJsonObject()) {
            dResult = jsonElement.getAsJsonObject().getAsDouble();
        }
        if (jsonElement.isJsonPrimitive()) {
            dResult = jsonElement.getAsJsonPrimitive().getAsDouble();
        }
        return dResult;
    }

    public static String getStringFromJsonElement(JsonElement jsonElement) {
        if (null == jsonElement) {
            return null;
        }
        String strResult = null;
        if (jsonElement.isJsonObject()) {
            strResult = jsonElement.getAsJsonObject().getAsString();
        }
        if (jsonElement.isJsonPrimitive()) {
            strResult = jsonElement.getAsJsonPrimitive().getAsString();
        }
        return strResult;
    }

    @Override
    public Object[] getResultFieldValues(String jqlRequest, String fieldName, Object valueIfNull, String appLinkName, boolean byFieldId) throws Exception {
        if (byFieldId && !fieldName.matches("[A-Za-z0-9 _]+")) {
            throw new Exception("The field '" + fieldName + "' name does not match the regexp \"[A-Za-z0-9 _]+\".");
        }
        ApplicationLink appLink = this.getAppLink(appLinkName);
        if (null == appLink) {
            throw new Exception("Unable to open appliction link with name '" + appLinkName + "'.");
        }
        JiraIssueFieldDescriptor fieldDescriptor = this.loadFieldDescriptor(appLink, byFieldId, fieldName);
        fieldName = fieldDescriptor.id;
        String applicationUrl = Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        ArrayList<Object> result = new ArrayList<Object>();
        long startAt = 0L;
        long maxResults = 1000L;
        long counter = 10000L;
        while (counter > 0L) {
            String jsRoot;
            block9: {
                --counter;
                String apiPath = applicationUrl + "/rest/api/2/search?jql=" + URLEncoder.encode(jqlRequest, StandardCharsets.UTF_8.toString());
                apiPath = apiPath + "&startAt=" + startAt;
                apiPath = apiPath + "&maxResults=" + maxResults;
                apiPath = apiPath + "&fields=" + URLEncoder.encode(fieldName, StandardCharsets.UTF_8.toString());
                ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, apiPath);
                jsRoot = "";
                if (Features.JQL_QUERY_RETURN_EMPTY_ARRAY_ON_EXCEPTION) {
                    try {
                        jsRoot = request.execute();
                        break block9;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                jsRoot = request.execute();
            }
            String objTotal = MathJqlQueryExecutor.extractValueFromJsonString(jsRoot, "total");
            if (null == objTotal || objTotal.toString().isEmpty()) {
                Object[] tmpResult = MathJqlQueryExecutor.extractValuesFromJsonString(jsRoot, fieldDescriptor, valueIfNull);
                if (null == tmpResult || tmpResult.length < 1) {
                    throw new Exception("Unable retrieve the 'total' field value from the result of REST API search function result");
                }
                return tmpResult;
            }
            long realTotal = Long.parseLong(objTotal.toString());
            Object[] tmpResult = MathJqlQueryExecutor.extractValuesFromJsonString(jsRoot, fieldDescriptor, valueIfNull);
            if (null == tmpResult || tmpResult.length < 1) break;
            int count = tmpResult.length;
            for (Object obj : tmpResult) {
                result.add(obj);
            }
            if ((startAt += (long)count) < realTotal) continue;
            break;
        }
        return result.toArray();
    }

    public static Object[] extractValuesFromJsonString(String jsonString, JiraIssueFieldDescriptor fieldDescriptor, Object valueIfNull) throws ParseException, JsonParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        JsonElement objRoot = JsonParser.parseString(jsonString);
        if (objRoot.isJsonObject()) {
            JsonObject rootObj = objRoot.getAsJsonObject();
            JsonElement objIssues = rootObj.get("issues");
            if (null == objIssues || !objIssues.isJsonArray()) {
                return new Object[0];
            }
            JsonArray issueArray = objIssues.getAsJsonArray();
            if (null == issueArray || issueArray.size() < 1) {
                return new Object[0];
            }
            int count = issueArray.size();
            for (int i = 0; i < count; ++i) {
                JsonElement objItem = issueArray.get(i);
                if (null == objItem || !objItem.isJsonObject()) {
                    result.add(valueIfNull);
                    continue;
                }
                JsonObject jsonItem = objItem.getAsJsonObject();
                Object fieldValue = MathJqlQueryExecutor.getFieldValueAsSimpleType(jsonItem, fieldDescriptor);
                result.add(null == fieldValue ? valueIfNull : fieldValue);
            }
            return result.toArray();
        }
        return new Object[0];
    }

    protected JiraIssueFieldDescriptor loadFieldDescriptor(ApplicationLink appLink, boolean byFieldId, String fieldNameOrId) throws Exception {
        String applicationUrl = Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        String apiPath = applicationUrl + "/rest/api/2/field";
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, apiPath);
        String jsRoot = "";
        if (Features.JQL_QUERY_RETURN_EMPTY_ARRAY_ON_EXCEPTION) {
            try {
                jsRoot = request.execute();
            }
            catch (Exception exception) {}
        } else {
            jsRoot = request.execute();
        }
        if (null == jsRoot || jsRoot.isEmpty()) {
            throw new Exception("The REST API call for the list of fields in '" + appLink.getName() + "' returned an empty list.");
        }
        JsonObject jsonDescriptor = MathJqlQueryExecutor.extractJsonObjectFromJsonString(jsRoot, byFieldId ? "id" : "name", fieldNameOrId);
        if (null == jsonDescriptor) {
            throw new Exception("The REST API call for the list of fields in '" + appLink.getName() + "' returned an empty descriptor.");
        }
        JiraIssueFieldDescriptor jiraIssueFieldDescriptor = MathJqlQueryExecutor.getJiraIssueFieldDescriptorFromJsonObject(jsonDescriptor);
        return jiraIssueFieldDescriptor;
    }

    public static JiraIssueFieldDescriptor getJiraIssueFieldDescriptorFromJsonObject(JsonObject jsonDescriptor) throws Exception {
        JsonObject jsonObject;
        String name = "";
        String id = "";
        boolean isCustom = false;
        String type = "";
        String custom = "";
        String items = "";
        String system = "";
        JsonElement jsonElem = jsonDescriptor.get("name");
        if (null != jsonElem) {
            name = jsonElem.getAsString();
        }
        if (null != (jsonElem = jsonDescriptor.get("id"))) {
            id = jsonElem.getAsString();
        }
        if (null != (jsonElem = jsonDescriptor.get("custom"))) {
            String strCustom = jsonElem.getAsString();
            boolean bl = isCustom = null != strCustom && strCustom.equalsIgnoreCase("true");
        }
        if (null != (jsonElem = jsonDescriptor.get("schema")) && jsonElem.isJsonObject() && null != (jsonObject = jsonElem.getAsJsonObject()) && jsonObject.isJsonObject()) {
            jsonElem = jsonObject.get("type");
            if (null != jsonElem) {
                type = jsonElem.getAsString();
            }
            if (null != (jsonElem = jsonObject.get("custom"))) {
                custom = jsonElem.getAsString();
            }
            if (null != (jsonElem = jsonObject.get("items"))) {
                items = jsonElem.getAsString();
            }
            if (null != (jsonElem = jsonObject.get("system"))) {
                system = jsonElem.getAsString();
            }
        }
        if (null == name || name.isEmpty()) {
            throw new Exception("Error in issue field descriptor: 'name' parameter shoud not be emoty.");
        }
        if (null == id || id.isEmpty()) {
            throw new Exception("Error in issue field descriptor: 'id' parameter shoud not be emoty.");
        }
        if (id.equalsIgnoreCase("issuekey")) {
            type = "string";
        }
        if (null == type || type.isEmpty()) {
            throw new Exception("Error in issue field descriptor: 'type' parameter shoud not be emoty.");
        }
        JiraIssueFieldDescriptor jiraIssueFieldDescriptor = new JiraIssueFieldDescriptor(name, id, isCustom, type, custom, items, system);
        return jiraIssueFieldDescriptor;
    }

    public static JsonObject extractJsonObjectFromJsonString(String jsonString, String key, String value) throws ParseException, JsonParseException, Exception {
        JsonElement objRoot = JsonParser.parseString(jsonString);
        if (objRoot.isJsonObject()) {
            JsonObject rootObj = objRoot.getAsJsonObject();
            JsonElement objKey = rootObj.get(key);
            if (null == objKey || objKey.toString().isEmpty()) {
                throw new Exception("Unable to find the descriptor for the field with " + key + " '" + value + "'.");
            }
            String stringValue = objKey.getAsString();
            if (null == stringValue || !stringValue.equalsIgnoreCase(value)) {
                throw new Exception("Cannot to find the descriptor for the field with " + key + " '" + value + "'.");
            }
            return rootObj;
        }
        if (objRoot.isJsonArray()) {
            JsonArray jsonArray = objRoot.getAsJsonArray();
            if (null == jsonArray || jsonArray.size() < 1) {
                throw new Exception("Unable to find the descriptor for the field " + key + " '" + value + "': the descriptions array is empty.");
            }
            for (JsonElement jsonElem : jsonArray) {
                String stringValue;
                JsonObject jsonObj;
                JsonElement objKey;
                if (null == jsonElem || !jsonElem.isJsonObject() || null == (objKey = (jsonObj = jsonElem.getAsJsonObject()).get(key)) || objKey.getAsString().isEmpty() || null == (stringValue = objKey.getAsString()) || !stringValue.equalsIgnoreCase(value)) continue;
                return jsonObj;
            }
            throw new Exception("Unable to find the descriptor for the field with " + key + " '" + value + "': the descriptor with such parameter was not found.");
        }
        throw new Exception("Unsupported JSON object type: '" + objRoot.getClass() + "'");
    }

    public Map<String, String> loadFieldDescriptions(String appLinkName) throws Exception {
        HashMap<String, String> result = new HashMap();
        ApplicationLink appLink = this.getAppLink(appLinkName);
        if (null == appLink) {
            throw new Exception("Unable to retrieve application link for '" + appLinkName + "'.");
        }
        String applicationUrl = Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        String apiPath = applicationUrl + "/rest/api/2/field";
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, apiPath);
        String jsRoot = "";
        if (Features.JQL_QUERY_RETURN_EMPTY_ARRAY_ON_EXCEPTION) {
            try {
                jsRoot = request.execute();
            }
            catch (Exception exception) {}
        } else {
            jsRoot = request.execute();
        }
        if (null == jsRoot || jsRoot.isEmpty()) {
            throw new Exception("The REST API call for the list of fields in '" + appLinkName + "' returned an empty list.");
        }
        result = MathJqlQueryExecutor.extractMapFromJsonString(jsRoot, "name", "id");
        return result;
    }

    public static Map<String, String> extractMapFromJsonString(String jsonString, String keyName, String valueName) throws ParseException, JsonParseException {
        JsonElement objRoot = JsonParser.parseString(jsonString);
        HashMap<String, String> result = new HashMap<String, String>();
        if (objRoot.isJsonObject()) {
            JsonObject rootObj = objRoot.getAsJsonObject();
            JsonElement objKey = rootObj.get(keyName);
            JsonElement objValue = rootObj.get(valueName);
            if (null == objKey || objKey.toString().isEmpty() || null == objValue || objValue.toString().isEmpty()) {
                return result;
            }
            String key = objKey.toString().toLowerCase();
            String value = objValue.toString().toLowerCase();
            result.put(key, value);
            return result;
        }
        if (objRoot.isJsonArray()) {
            JsonArray jsonArray = objRoot.getAsJsonArray();
            if (null == jsonArray || jsonArray.size() < 1) {
                return result;
            }
            for (JsonElement jsonElem : jsonArray) {
                if (null == jsonElem || !jsonElem.isJsonObject()) continue;
                JsonObject jsonObj = jsonElem.getAsJsonObject();
                JsonElement objKey = jsonObj.get(keyName);
                JsonElement objValue = jsonObj.get(valueName);
                if (null == objKey || objKey.getAsString().isEmpty() || null == objValue || objValue.getAsString().isEmpty()) {
                    return result;
                }
                String key = objKey.getAsString().toLowerCase();
                String value = objValue.getAsString().toLowerCase();
                result.put(key, value);
            }
            return result;
        }
        return result;
    }

    protected ApplicationLink getAppLink(String appLinkName) throws Exception {
        if (null == this.applicationLinkService) {
            throw new Exception("Unable to retrieve the application link for '" + appLinkName + "' due to not initialized application link service object.");
        }
        Iterable appLinks = null;
        if (null != appLinkName && !appLinkName.isEmpty()) {
            appLinks = this.applicationLinkService.getApplicationLinks(JiraApplicationType.class);
            if (null == appLinks) {
                throw new Exception("Unable to retrieve the list of application links.");
            }
            for (ApplicationLink appLink : appLinks) {
                String thisLinkName;
                if (null == appLink || null == (thisLinkName = appLink.getName()) || 0 != thisLinkName.compareTo(appLinkName)) continue;
                return appLink;
            }
            throw new Exception("Unable to find the application link '" + appLinkName + "' in the list of application links.");
        }
        ApplicationLink appLink = this.applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class);
        if (null == appLink) {
            throw new Exception("Unable to retrieve default application link. Try to specify an exact application link name.");
        }
        return appLink;
    }
}

