/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.math;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AuthenticationContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import java.io.File;
import java.io.FileInputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class CelestecsMathRestService {
    private static String PROP_FILE_NAME = "celestecs-math.properties";
    private static String PROP_NAME_PERMISSIONS_CHECK_ENABLED = "PermissionCheckEnabled";
    private static String PROP_NAME_ALERT_UNAUTHORIZED_MACRO_USE = "AlertUnauthorizedMacroUse";
    private static String PROP_NAME_TRUSTED_GROUPS = "TrustedGroups";
    private static String PROP_NAME_TRUSTED_USERS = "TrustedUsers";
    private static String PROP_NAME_NOT_TRUSTED_GROUPS = "NotTrustedGroups";
    private static String PROP_NAME_NOT_TRUSTED_USERS = "NotTrustedUsers";
    private final I18nResolver i18n;
    private final UserAccessor userAccessor;

    public CelestecsMathRestService(I18nResolver i18n, UserAccessor userAccessor) {
        this.i18n = i18n;
        this.userAccessor = userAccessor;
    }

    public static void Log(String str) {
    }

    @GET
    @Path(value="/checkFuncAvailability")
    public Response checkFuncAvailability(@Context AuthenticationContext authenticationContext) {
        boolean allowMacroBrowser;
        User user;
        String userName;
        Principal principal;
        CelestecsMathRestService.Log("Checking functionality availability");
        if (!CelestecsMathRestService.getPermissionsCheckEnabled()) {
            return this.buildOkResponse("PluginManagementIsAllowed", "true", "User permissions are NOT checked");
        }
        if (authenticationContext != null && (principal = authenticationContext.getPrincipal()) != null && null != (userName = principal.getName()) && userName.length() > 0 && null != (user = this.userAccessor.getUser(userName)) && (allowMacroBrowser = CelestecsMathRestService.getAllowMacroBrowser(user, this.userAccessor))) {
            return this.buildOkResponse("PluginManagementIsAllowed", "true", "User permissions are checked");
        }
        CelestecsMathRestService.Log("Unauthorized macro use");
        return this.buildOkResponse("PluginManagementIsAllowed", "false", CelestecsMathRestService.getAlertMacroUnauthorizedText(this.i18n.getText("com.celestecs.confluence.math.numerical-expression.permissions.management-not-allowed")));
    }

    private Response buildOkResponse(String headerValueName, String headerValue, String additionalInfo) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.OK);
        responseBuilder.entity((Object)additionalInfo);
        responseBuilder.type("text/plain");
        responseBuilder.header(headerValueName, (Object)headerValue);
        Response response = responseBuilder.build();
        return response;
    }

    public static boolean mayEditMacro(UserAccessor userAccessor) {
        boolean allowMacroBrowser;
        if (null == userAccessor) {
            return true;
        }
        if (!CelestecsMathRestService.getPermissionsCheckEnabled()) {
            return true;
        }
        User user = AuthenticatedUserThreadLocal.getUser();
        return null != user && (allowMacroBrowser = CelestecsMathRestService.getAllowMacroBrowser(user, userAccessor));
    }

    private static boolean getAllowMacroBrowser(User user, UserAccessor userAccessor) {
        if (userAccessor.hasMembership("confluence-administrators", user.getName())) {
            return true;
        }
        ArrayList<String> propToRead = new ArrayList<String>();
        propToRead.add(PROP_NAME_TRUSTED_GROUPS);
        propToRead.add(PROP_NAME_TRUSTED_USERS);
        propToRead.add(PROP_NAME_NOT_TRUSTED_GROUPS);
        propToRead.add(PROP_NAME_NOT_TRUSTED_USERS);
        Map<String, String> props = CelestecsMathRestService.readProps(propToRead);
        String propTrustedGroups = props.containsKey(PROP_NAME_TRUSTED_GROUPS) ? props.get(PROP_NAME_TRUSTED_GROUPS) : "";
        String propTrustedUsers = props.containsKey(PROP_NAME_TRUSTED_USERS) ? props.get(PROP_NAME_TRUSTED_USERS) : "";
        String propNotTrustedGroups = props.containsKey(PROP_NAME_NOT_TRUSTED_GROUPS) ? props.get(PROP_NAME_NOT_TRUSTED_GROUPS) : "";
        String propNotTrustedUsers = props.containsKey(PROP_NAME_NOT_TRUSTED_USERS) ? props.get(PROP_NAME_NOT_TRUSTED_USERS) : "";
        String[] strTrustedGroups = propTrustedGroups.split(",");
        String[] strTrustedUsers = propTrustedUsers.split(",");
        String[] strNotTrustedGroups = propNotTrustedGroups.split(",");
        String[] strNotTrustedUsers = propNotTrustedUsers.split(",");
        String userName = user.getName();
        boolean userIsInTrustedGroup = CelestecsMathRestService.hasMembership(strTrustedGroups, userName, userAccessor);
        boolean userIsInTrustedUsers = CelestecsMathRestService.isUserInTheList(strTrustedUsers, userName);
        boolean userIsInUntrustedGroup = CelestecsMathRestService.hasMembership(strNotTrustedGroups, userName, userAccessor);
        boolean userIsInUntrustedUsers = CelestecsMathRestService.isUserInTheList(strNotTrustedUsers, userName);
        boolean userIsTrusted = userIsInTrustedGroup || userIsInTrustedUsers;
        boolean userIsUntrusted = userIsInUntrustedGroup || userIsInUntrustedUsers;
        boolean trusted = userIsTrusted && !userIsUntrusted;
        return trusted;
    }

    private static boolean hasMembership(String[] groups, String userName, UserAccessor userAccessor) {
        int size = null == groups ? 0 : groups.length;
        for (int i = 0; i < size; ++i) {
            String groupName = groups[i];
            if (null == groupName || groupName.length() < 1 || !userAccessor.hasMembership(groupName.trim(), userName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUserInTheList(String[] userNames, String userName) {
        int size = null == userNames ? 0 : userNames.length;
        for (int i = 0; i < size; ++i) {
            String userNameToCompare = userNames[i];
            if (null == userNameToCompare || userNameToCompare.length() < 1 || userNameToCompare.trim().compareToIgnoreCase(userName) != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean getPermissionsCheckEnabled() {
        ArrayList<String> propToRead = new ArrayList<String>();
        propToRead.add(PROP_NAME_PERMISSIONS_CHECK_ENABLED);
        Map<String, String> props = CelestecsMathRestService.readProps(propToRead);
        if (props.containsKey(PROP_NAME_PERMISSIONS_CHECK_ENABLED)) {
            String strPermissionCheckEnabled = props.get(PROP_NAME_PERMISSIONS_CHECK_ENABLED);
            return null != strPermissionCheckEnabled && 0 == strPermissionCheckEnabled.compareToIgnoreCase("true");
        }
        return false;
    }

    private static String getAlertMacroUnauthorizedText(String altText) {
        ArrayList<String> propToRead = new ArrayList<String>();
        propToRead.add(PROP_NAME_ALERT_UNAUTHORIZED_MACRO_USE);
        Map<String, String> props = CelestecsMathRestService.readProps(propToRead);
        if (props.containsKey(PROP_NAME_ALERT_UNAUTHORIZED_MACRO_USE)) {
            String strUnauthorizedMacroUse = props.get(PROP_NAME_ALERT_UNAUTHORIZED_MACRO_USE);
            if (null != strUnauthorizedMacroUse && strUnauthorizedMacroUse.trim().length() > 0) {
                return strUnauthorizedMacroUse.trim();
            }
            return altText;
        }
        return altText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> readProps(List<String> propsToRead) {
        HashMap<String, String> result = new HashMap<String, String>();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            String applicationHome = BootstrapUtils.getBootstrapManager().getApplicationHome();
            file = new File(applicationHome, PROP_FILE_NAME);
            fileInputStream = new FileInputStream(file);
            Properties p = new Properties();
            p.load(fileInputStream);
            for (int i = 0; i < propsToRead.size(); ++i) {
                String key = propsToRead.get(i);
                String value = p.getProperty(key);
                if (null == value || value.trim().length() <= 0) continue;
                result.put(key, value);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                    fileInputStream = null;
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    protected boolean exemptDeveloperLicense() {
        return false;
    }

    protected boolean exemptOnDemand() {
        return false;
    }
}

